/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class ValueRecordsRemover
extends AbstractInconsistencyRepair {
    private final String containerName;
    private final boolean multiDb;

    public ValueRecordsRemover(WorkspaceStorageConnectionFactory connFactory, String containerName, boolean multiDb) {
        super(connFactory);
        this.containerName = containerName;
        this.multiDb = multiDb;
    }

    void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            String propertyId = this.exctractId(resultSet, "PROPERTY_ID");
            QPath path = QPath.parse("[]");
            TransientPropertyData data = new TransientPropertyData(path, propertyId, 0, 0, null, false, new ArrayList<ValueData>());
            conn.delete(data);
        }
        catch (IllegalPathException e) {
            throw new SQLException((Throwable)((Object)e));
        }
        catch (UnsupportedOperationException e) {
            throw new SQLException(e);
        }
        catch (JCRInvalidItemStateException e) {
        }
        catch (InvalidItemStateException e) {
            throw new SQLException(e);
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
    }

    protected String exctractId(ResultSet resultSet, String column) throws SQLException {
        return resultSet.getString(column).substring(this.multiDb ? 0 : this.containerName.length());
    }
}

