/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.BitStack;
import org.exoplatform.web.controller.router.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderContext {
    private final Map<QualifiedName, Parameter> parameters;
    private BitStack stack = new BitStack();
    Regex.Matcher[] matchers = null;

    public RenderContext(Map<QualifiedName, String> map) {
        this();
        this.reset(map);
    }

    public RenderContext() {
        this.parameters = new HashMap<QualifiedName, Parameter>();
        this.stack = new BitStack();
    }

    Regex.Matcher matcher(Regex regex) {
        Regex.Matcher matcher = this.matchers[regex.index];
        if (matcher == null) {
            matcher = this.matchers[regex.index] = regex.matcher();
        }
        return matcher;
    }

    public void reset(Map<QualifiedName, String> map) {
        this.parameters.clear();
        this.stack.reset();
        for (Map.Entry<QualifiedName, String> entry : map.entrySet()) {
            this.addParameter(entry.getKey(), entry.getValue());
        }
    }

    void addParameter(QualifiedName name, String value) {
        if (this.stack.getDepth() > 0) {
            throw new IllegalStateException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        Parameter parameter = this.parameters.get(name);
        if (parameter == null) {
            parameter = new Parameter(value, this.parameters.size());
            this.parameters.put(name, parameter);
        } else {
            parameter.value = value;
        }
    }

    Parameter getParameter(QualifiedName name) {
        return this.parameters.get(name);
    }

    Iterable<QualifiedName> getNames() {
        return this.parameters.keySet();
    }

    boolean isEmpty() {
        return this.stack.getDepth() == 0 || this.stack.isEmpty();
    }

    void enter() {
        if (this.stack.getDepth() == 0) {
            this.stack.init(this.parameters.size());
        }
        this.stack.push();
    }

    void leave() {
        this.stack.pop();
    }

    class Parameter {
        private String value;
        private final int index;
        private String match;

        private Parameter(String value, int index) {
            this.value = value;
            this.index = index;
        }

        public String getValue() {
            return this.value;
        }

        public String getMatch() {
            return this.isMatched() ? this.match : null;
        }

        public boolean isMatched() {
            return RenderContext.this.stack.getDepth() > 0 && RenderContext.this.stack.get(this.index);
        }

        public void remove(String match) {
            if (RenderContext.this.stack.getDepth() < 1) {
                throw new IllegalStateException();
            }
            if (RenderContext.this.stack.get(this.index)) {
                throw new AssertionError((Object)"We should not do that twice, shouldn't we ?");
            }
            RenderContext.this.stack.set(this.index);
            this.match = match;
        }
    }
}

