/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.personalfolder.services;

import java.util.List;
import javax.jcr.Node;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.AddPathPlugin;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class ManagePersonalFolderServiceImpl {
    private static final Log LOG = ExoLogger.getLogger((String)ManagePersonalFolderServiceImpl.class.getName());
    private final HierarchyConfig config_;
    private final NodeHierarchyCreator nodeHierarchyCreatorService_;
    private final DataDistributionType dataDistributionType_;

    public ManagePersonalFolderServiceImpl(NodeHierarchyCreator nodeHierarchyCreatorService, DataDistributionManager dataDistributionManager, InitParams params) {
        this.dataDistributionType_ = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
        this.config_ = (HierarchyConfig)params.getObjectParamValues(HierarchyConfig.class).get(0);
        nodeHierarchyCreatorService.addPlugin((ComponentPlugin)new AddPathPlugin(params));
        this.nodeHierarchyCreatorService_ = nodeHierarchyCreatorService;
    }

    public void initUserFolder(String userName) {
        try {
            Node userNode = this.nodeHierarchyCreatorService_.getUserNode(WCMCoreUtils.getSystemSessionProvider(), userName);
            List jcrPaths = this.config_.getJcrPaths();
            for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
                this.dataDistributionType_.getOrCreateDataNode(userNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions(userName));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("An error occurs while initializing the user directory of '" + userName + "'"), (Throwable)e);
        }
    }
}

