/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.extensions.component.rest;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/authoring/")
public class LifecycleConnector
implements ResourceContainer {
    private static final Log log = ExoLogger.getLogger(LifecycleConnector.class);

    @GET
    @Path(value="/bystate/")
    public Response byState(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="user") String user, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, null, null, user, lang, workspace, json);
    }

    @GET
    @Path(value="/tostate/")
    public Response toState(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="tostate") String tostate, @QueryParam(value="user") String user, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, tostate, null, user, lang, workspace, json);
    }

    @GET
    @Path(value="/bydate/")
    public Response byDate(@QueryParam(value="fromstate") String fromstate, @QueryParam(value="date") String date, @QueryParam(value="lang") String lang, @QueryParam(value="workspace") String workspace, @QueryParam(value="json") String json) throws Exception {
        return this.getContents(fromstate, null, date, null, lang, workspace, json);
    }

    private Response getContents(String fromstate, String tostate, String date, String user, String lang, String workspace, String asJSon) throws Exception {
        try {
            boolean first;
            StringBuffer json = new StringBuffer();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("contents");
            document.appendChild(root);
            PublicationManager manager = (PublicationManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PublicationManager.class);
            WCMComposer wcmComposer = (WCMComposer)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WCMComposer.class);
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("filter-mode", "Edit");
            filters.put("filter-language", lang);
            StringBuffer query = new StringBuffer("select * from nt:base where publication:currentState='" + fromstate + "'");
            if (tostate != null) {
                List<LifecyclesConfig.Lifecycle> lifecycles = manager.getLifecyclesFromUser(user, tostate);
                if (lifecycles != null && !lifecycles.isEmpty()) {
                    query.append(" and (");
                    first = true;
                    for (LifecyclesConfig.Lifecycle lifecycle : lifecycles) {
                        if (!first) {
                            query.append(" or ");
                        }
                        first = false;
                        query.append("publication:lifecycle='" + lifecycle.getName() + "'");
                    }
                    query.append(")");
                } else {
                    query.append(" and publication:lifecycle='_no_lifecycle'");
                }
            } else if (user != null) {
                query.append(" and publication:lastUser='" + user + "'");
            }
            if (date != null) {
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).add(6, Integer.parseInt(date));
                query.append(" and publication:startPublishedDate<=TIMESTAMP '" + this.getISO8601Date(cal) + "'");
                query.append(" order by publication:startPublishedDate asc");
            }
            filters.put("filter-query-full", query.toString());
            if (log.isInfoEnabled()) {
                log.info((Object)("query=" + query.toString()));
            }
            List nodes = wcmComposer.getContents("repository", workspace, "/", filters, WCMCoreUtils.getUserSessionProvider());
            json.append("[");
            first = true;
            for (Node node : nodes) {
                String pubDate;
                String name = node.getName();
                String path = node.getPath();
                String string = pubDate = node.hasProperty("publication:startPublishedDate") ? node.getProperty("publication:startPublishedDate").getString() : null;
                if (!first) {
                    json.append(",");
                }
                first = false;
                json.append("{");
                json.append("\"name\":\"" + name + "\"");
                json.append(",\"path\":\"" + path + "\"");
                Element element = document.createElement("content");
                element.setAttribute("name", name);
                element.setAttribute("path", path);
                if (pubDate != null) {
                    json.append(",\"publishedDate\":\"" + pubDate + "\"");
                    element.setAttribute("publishedDate", pubDate);
                }
                root.appendChild(element);
                json.append("}");
            }
            json.append("]");
            if ("true".equals(asJSon)) {
                return Response.ok((Object)json.toString(), (String)"text/plain").build();
            }
            return Response.ok((Object)new DOMSource(document), (String)"text/xml").build();
        }
        catch (Exception e) {
            Response.serverError().build();
            return Response.ok().build();
        }
    }

    private String getISO8601Date(Calendar cal) {
        DateTime dt = new DateTime(cal.getTimeInMillis());
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        String str = fmt.print((ReadableInstant)dt);
        return str;
    }
}

