/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.scheduler.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.AuthoringPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ChangeStateCronJobImpl
implements Job {
    private static final Log log = ExoLogger.getLogger(ChangeStateCronJobImpl.class);
    private static final String START_TIME_PROPERTY = "publication:startPublishedDate".intern();
    private static final String END_TIME_PROPERTY = "publication:endPublishedDate".intern();
    private String fromState = null;
    private String toState = null;
    private String predefinedPath = null;
    private String workspace = null;
    private String repository = null;
    private String contentPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Session session = null;
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            if (mx.getUptime() > 120000L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Start Execute ChangeStateCronJob");
                }
                if (this.fromState == null) {
                    JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
                    this.fromState = jdatamap.getString("fromState");
                    this.toState = jdatamap.getString("toState");
                    this.predefinedPath = jdatamap.getString("predefinedPath");
                    String[] pathTab = this.predefinedPath.split(":");
                    this.repository = pathTab[0];
                    this.workspace = pathTab[1];
                    this.contentPath = pathTab[2];
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start Execute ChangeStateCronJob: change the State from " + this.fromState + " to " + this.toState));
                }
                SessionProvider sessionProvider = SessionProvider.createSystemProvider();
                String containerName = WCMCoreUtils.getContainerNameFromJobContext((JobExecutionContext)context);
                RepositoryService repositoryService_ = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class, (String)containerName);
                PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class, (String)containerName);
                ManageableRepository manageableRepository = repositoryService_.getRepository(this.repository);
                if (manageableRepository == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Repository '" + this.repository + "' not found., ignoring"));
                    }
                    return;
                }
                session = sessionProvider.getSession(this.workspace, manageableRepository);
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                String property = null;
                if ("staged".equals(this.fromState) && "published".equals(this.toState)) {
                    property = START_TIME_PROPERTY;
                } else if ("published".equals(this.fromState) && "unpublished".equals(this.toState)) {
                    property = END_TIME_PROPERTY;
                }
                if (property != null) {
                    Query query;
                    QueryResult queryResult;
                    long numberOfItemsToChange;
                    if (this.contentPath != null && !this.contentPath.endsWith("/")) {
                        this.contentPath = this.contentPath + "/";
                    }
                    if ((numberOfItemsToChange = (queryResult = (query = queryManager.createQuery("select * from nt:base where publication:currentState='" + this.fromState + "'" + " and jcr:path like '" + this.contentPath + "%'", "sql")).execute()).getNodes().getSize()) > 0L) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(numberOfItemsToChange + " '" + this.fromState + "' candidates for state '" + this.toState + "' found in " + this.predefinedPath));
                        }
                        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(AuthoringPublicationConstant.LIFECYCLE_NAME);
                        HashMap<String, String> context_ = new HashMap<String, String>();
                        context_.put("containerName", containerName);
                        NodeIterator iter = queryResult.getNodes();
                        while (iter.hasNext()) {
                            Node node_ = iter.nextNode();
                            String path = node_.getPath();
                            if (path.startsWith("/jcr:system")) continue;
                            if (node_.hasProperty(property)) {
                                Node liveRevision;
                                String liveRevisionProperty;
                                Date nodeDate;
                                SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy - HH:mm");
                                Date now = Calendar.getInstance().getTime();
                                if (now.compareTo(nodeDate = node_.getProperty(property).getDate().getTime()) < 0) continue;
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("'" + this.toState + "' " + node_.getPath() + " (" + property + "=" + format.format(nodeDate) + ")"));
                                }
                                if ("unpublished".equals(this.toState) && node_.hasProperty(StageAndVersionPublicationConstant.LIVE_REVISION_PROP) && !"".equals(liveRevisionProperty = node_.getProperty(StageAndVersionPublicationConstant.LIVE_REVISION_PROP).getString()) && (liveRevision = session.getNodeByUUID(liveRevisionProperty)) != null) {
                                    context_.put(AuthoringPublicationConstant.CURRENT_REVISION_NAME, liveRevision.getName());
                                }
                                publicationPlugin.changeState(node_, this.toState, context_);
                                continue;
                            }
                            if (!START_TIME_PROPERTY.equals(property)) continue;
                            if (log.isInfoEnabled()) {
                                log.info((Object)("'" + this.toState + "' " + node_.getPath()));
                            }
                            publicationPlugin.changeState(node_, this.toState, context_);
                        }
                    } else if (log.isInfoEnabled()) {
                        log.info((Object)("no '" + this.fromState + "' content found in " + this.predefinedPath));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"End Execute ChangeStateCronJob");
                }
            }
        }
        catch (RepositoryException ex) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Repository '" + this.repository + "' not found., ignoring"));
            }
        }
        catch (Exception ex) {
            log.error((Object)("error when changing the state of the content : " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

