/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.ecm.webui.component.browsecontent.UINewConfigForm;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={NextActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={OnChangeActionListener.class})})
public class UINewConfigForm
extends UIForm {
    public static final String FIELD_REPOSITORY = "repository";
    public static final String FIELD_WORKSPACE = "workspace";
    public static final String FIELD_BROWSETYPE = "browseType";
    public static final String FIELD_TEMPLATE = "template";
    public static final String FIELD_DETAILBOXTEMP = "detailBoxTemp";
    public static final String FIELD_QUERYLANG = "queryLanguage";
    public static final String FIELD_QUERYSTATUS = "queryStatus";
    public static final String FIELD_QUERYSTORE = "queryStore";
    public static final String FIELD_QUERYTYPE = "queryType";
    public static final String FIELD_CATEGORYPATH = "categoryPath";
    public static final String FIELD_SCRIPTNAME = "scriptName";
    public static final String FIELD_DOCNAME = "docName";
    public static final String FIELD_ITEMPERPAGE = "itemPerPage";
    public static final String FIELD_ENABLETOOLBAR = "enableToolBar";
    public static final String FIELD_ALLOW_PUBLISH = "isAllowPublish".intern();
    public static final String FIELD_ENABLEREFDOC = "enableRefDoc";
    public static final String FIELD_FILTER_CATEGORY = "filterCategory";
    public static final String FIELD_ENABLECHILDDOC = "enableChildDoc";
    public static final String FIELD_ENABLETAGMAP = "enableTagMap";
    public static final String FIELD_ENABLECOMMENT = "enableComment";
    public static final String FIELD_ENABLEVOTE = "enableVote";
    public static final String FIELD_QUERY = "query";
    public static final String FIELD_SEARCH_LOCATION = "searchLocation";
    public static final String FIELD_SEARCH_PATH_ENABLE = "searchEnable";
    public static final String[] DEFAULT_ACTION = new String[]{"Edit", "Add"};
    public static final String[] NORMAL_ACTION = new String[]{"Save", "Cancel"};
    public static final String[] ADD_NEW_ACTION = new String[]{"Back", "Save"};

    public UINewConfigForm() throws Exception {
        UIFormSelectBox repoSelectBox = new UIFormSelectBox(FIELD_REPOSITORY, FIELD_REPOSITORY, this.getRepoOption());
        repoSelectBox.setOnChange("OnChange");
        this.addChild((UIComponent)repoSelectBox);
        String repo = (String)repoSelectBox.getValue();
        this.addChild((UIComponent)new UIFormSelectBox(FIELD_WORKSPACE, FIELD_WORKSPACE, this.getWorkSpaceOption(repo)));
        this.addChild((UIComponent)new UIFormSelectBox(FIELD_BROWSETYPE, FIELD_BROWSETYPE, this.getBrowseTypeOption()));
        this.setActions(new String[]{"Back", "Next"});
    }

    public void resetForm() throws Exception {
        UIFormSelectBox repoField = this.getUIFormSelectBox(FIELD_REPOSITORY);
        repoField.setOptions(this.getRepoOption());
        this.getUIFormSelectBox(FIELD_WORKSPACE).setOptions(this.getWorkSpaceOption((String)repoField.getValue()));
        this.getUIFormSelectBox(FIELD_WORKSPACE).reset();
        this.getUIFormSelectBox(FIELD_BROWSETYPE).setOptions(this.getBrowseTypeOption());
        this.getUIFormSelectBox(FIELD_BROWSETYPE).reset();
    }

    private List<SelectItemOption<String>> getRepoOption() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        RepositoryEntry repo = repositoryService.getCurrentRepository().getConfiguration();
        options.add(new SelectItemOption(repo.getName(), (Object)repo.getName()));
        return options;
    }

    private List<SelectItemOption<String>> getWorkSpaceOption(String repository) throws Exception {
        String[] workspaceNames;
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (String workspace : workspaceNames = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getWorkspaceNames()) {
            options.add((SelectItemOption<String>)new SelectItemOption(workspace, (Object)workspace));
        }
        return options;
    }

    private List<SelectItemOption<String>> getBrowseTypeOption() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(Utils.FROM_PATH, (Object)Utils.CB_USE_FROM_PATH));
        options.add(new SelectItemOption(Utils.USE_JCR_QUERY, (Object)Utils.CB_USE_JCR_QUERY));
        options.add(new SelectItemOption(Utils.USE_SCRIPT, (Object)Utils.CB_USE_SCRIPT));
        options.add(new SelectItemOption(Utils.USE_DOCUMENT, (Object)Utils.CB_USE_DOCUMENT));
        return options;
    }

    static /* synthetic */ List access$000(UINewConfigForm x0, String x1) throws Exception {
        return x0.getWorkSpaceOption(x1);
    }
}

