/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.NoneHTMLValidator;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UISubcriptionForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NameValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteModeratorActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectMemberActionListener.class}, phase=Event.Phase.DECODE)})
public class UISubcriptionForm
extends UIForm
implements UIPopupComponent,
UISelectable {
    private static final String INPUT_SUBCRIPTION_NAME = "SubcriptionName";
    private static final String INPUT_SUBCRIPTION_DESCRIPTION = "SubcriptionDescription";
    private static final String INPUT_SUBCRIPTION_TITLE = "SubcriptionTitle";
    private static final String SELECT_CATEGORIES_NAME = "CategoryName";
    public static final String SELECT_REDACTOR = "UIWCMSubscriptionRedactor";
    public static final String FORM_SUBSCRIPTION_REDACTOR = "UIWCMFormSubscriptionRedactor";
    private NewsletterCategoryHandler categoryHandler = null;
    private NewsletterSubscriptionConfig subscriptionConfig = null;
    private String popupId;
    private boolean isRemove;

    public boolean isRemove() {
        return this.isRemove;
    }

    public void setRemove(boolean isRemove) {
        this.isRemove = isRemove;
    }

    public UISubcriptionForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
        List categories = this.getListCategories();
        ArrayList<SelectItemOption> listCategoriesName = new ArrayList<SelectItemOption>();
        SelectItemOption option = null;
        for (NewsletterCategoryConfig category : categories) {
            option = new SelectItemOption(category.getTitle(), (Object)category.getName());
            listCategoriesName.add(option);
        }
        UIFormStringInput inputSubcriptionName = new UIFormStringInput(INPUT_SUBCRIPTION_NAME, null);
        inputSubcriptionName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(NameValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]);
        UIFormStringInput inputSubcriptionTitle = new UIFormStringInput(INPUT_SUBCRIPTION_TITLE, null);
        inputSubcriptionTitle.addValidator(MandatoryValidator.class, new Object[0]).addValidator(NoneHTMLValidator.class, new Object[0]);
        UIFormStringInput inputModerator = new UIFormStringInput(SELECT_REDACTOR, SELECT_REDACTOR, null);
        inputModerator.setEditable(false);
        inputModerator.addValidator(MandatoryValidator.class, new Object[0]);
        UIFormInputSetWithAction formSubscriptionDeractor = new UIFormInputSetWithAction(FORM_SUBSCRIPTION_REDACTOR);
        formSubscriptionDeractor.addChild((UIComponent)inputModerator);
        formSubscriptionDeractor.setActionInfo(SELECT_REDACTOR, new String[]{"SelectUser", "SelectMember", "DeleteModerator"});
        formSubscriptionDeractor.showActionInfo(true);
        UIFormTextAreaInput descriptionInput = new UIFormTextAreaInput(INPUT_SUBCRIPTION_DESCRIPTION, null, null);
        descriptionInput.addValidator(NoneHTMLValidator.class, new Object[0]);
        this.addChild((UIComponent)new UIFormSelectBox(SELECT_CATEGORIES_NAME, SELECT_CATEGORIES_NAME, listCategoriesName));
        this.addChild((UIComponent)inputSubcriptionName);
        this.addChild((UIComponent)inputSubcriptionTitle);
        this.addChild((UIComponent)descriptionInput);
        this.addChild((UIComponent)formSubscriptionDeractor);
    }

    public void doSelect(String selectField, Object value) throws Exception {
        UIFormInputSetWithAction formCategoryModerator = (UIFormInputSetWithAction)this.getChildById(FORM_SUBSCRIPTION_REDACTOR);
        UIFormStringInput stringInput = (UIFormStringInput)formCategoryModerator.getChildById(selectField);
        ArrayList<String> values = new ArrayList<String>();
        String oldValue = (String)stringInput.getValue();
        if (oldValue != null && oldValue.length() > 0) {
            values.addAll(Arrays.asList(oldValue.split(",")));
        }
        if (!values.contains((String)value)) {
            values.add((String)value);
        }
        StringBuffer sbResult = new StringBuffer();
        for (String str : values) {
            if (sbResult.toString().trim().length() > 0) {
                sbResult.append(",");
            }
            sbResult.append(str);
        }
        stringInput.setValue((Object)sbResult.toString());
        Utils.closePopupWindow((UIContainer)this, (String)this.popupId);
    }

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public void setSubscriptionInfor(NewsletterSubscriptionConfig subscriptionConfig) {
        if (subscriptionConfig == null) {
            return;
        }
        this.subscriptionConfig = subscriptionConfig;
        UIFormStringInput inputName = (UIFormStringInput)this.getChildById(INPUT_SUBCRIPTION_NAME);
        inputName.setValue((Object)subscriptionConfig.getName());
        inputName.setEditable(false);
        ((UIFormStringInput)this.getChildById(INPUT_SUBCRIPTION_TITLE)).setValue((Object)subscriptionConfig.getTitle());
        ((UIFormTextAreaInput)this.getChildById(INPUT_SUBCRIPTION_DESCRIPTION)).setValue((Object)subscriptionConfig.getDescription());
        UIFormSelectBox formSelectBox = (UIFormSelectBox)this.getChildById(SELECT_CATEGORIES_NAME);
        formSelectBox.setValue(subscriptionConfig.getCategoryName());
        formSelectBox.setDisabled(true);
        UIFormInputSetWithAction inputSetWithAction = (UIFormInputSetWithAction)this.getChildById(FORM_SUBSCRIPTION_REDACTOR);
        UIFormStringInput inputModerator = (UIFormStringInput)inputSetWithAction.getChildById(SELECT_REDACTOR);
        inputModerator.setValue((Object)subscriptionConfig.getRedactor());
    }

    private List<NewsletterCategoryConfig> getListCategories() {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.categoryHandler = newsletterManagerService.getCategoryHandler();
        try {
            return this.categoryHandler.getListCategories(NewsLetterUtil.getPortalName(), Utils.getSessionProvider());
        }
        catch (Exception e) {
            return new ArrayList<NewsletterCategoryConfig>();
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ NewsletterSubscriptionConfig access$000(UISubcriptionForm x0) {
        return x0.subscriptionConfig;
    }
}

