/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.config.NewsletterManagerConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterEntryHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryManager;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/newsletter/NewsletterManager/UINewsletterEntryManager.gtmpl", events={@EventConfig(listeners={AddEntryActionListener.class}), @EventConfig(listeners={BackToSubcriptionsActionListener.class}), @EventConfig(listeners={BackToCategoriesActionListener.class}), @EventConfig(listeners={OpenNewsletterActionListener.class}), @EventConfig(listeners={ConvertTemplateActionListener.class}), @EventConfig(listeners={EditNewsletterEntryActionListener.class}), @EventConfig(listeners={DeleteNewsletterEntryActionListener.class}), @EventConfig(listeners={SelectNewsletterActionListener.class})})
public class UINewsletterEntryManager
extends UIForm {
    private UIFormCheckBoxInput<Boolean> checkBoxInput;
    private NewsletterSubscriptionConfig subscriptionConfig;
    private NewsletterCategoryConfig categoryConfig;
    private List<NewsletterManagerConfig> listNewsletterConfig;
    private NewsletterEntryHandler newsletterEntryHandler;
    private String PAGEITERATOR_ID = "NewsletterEntryManagerPageIterator";
    private UIPageIterator uiPageIterator_;

    public UINewsletterEntryManager() throws Exception {
        NewsletterManagerService newsletterManagerService = (NewsletterManagerService)this.getApplicationComponent(NewsletterManagerService.class);
        this.newsletterEntryHandler = newsletterManagerService.getEntryHandler();
    }

    public void init() throws Exception {
        ListAccessImpl newsletterList = new ListAccessImpl(NewsletterManagerConfig.class, this.setListNewsletterEntries());
        LazyPageList dataPageList = new LazyPageList((ListAccess)newsletterList, 10);
        this.uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, this.PAGEITERATOR_ID);
        this.addChild((UIComponent)this.uiPageIterator_);
        this.uiPageIterator_.setPageList((PageList)dataPageList);
    }

    private List<NewsletterManagerConfig> setListNewsletterEntries() {
        this.getChildren().clear();
        this.listNewsletterConfig = new ArrayList();
        try {
            this.listNewsletterConfig.addAll(this.newsletterEntryHandler.getNewsletterEntriesBySubscription(WCMCoreUtils.getUserSessionProvider(), NewsLetterUtil.getPortalName(), this.categoryConfig.getName(), this.subscriptionConfig.getName()));
            for (NewsletterManagerConfig newletter : this.listNewsletterConfig) {
                this.checkBoxInput = new UIFormCheckBoxInput(newletter.getNewsletterName(), newletter.getNewsletterName(), (Object)false);
                this.addChild((UIComponent)this.checkBoxInput);
            }
        }
        catch (Exception ex) {
            Utils.createPopupMessage((UIContainer)this, (String)"UINewsletterEntryManager.msg.set-list-newsletter", null, (int)0);
        }
        return this.listNewsletterConfig;
    }

    public List getListNewsletterEntries() throws Exception {
        if (this.uiPageIterator_ != null) {
            return this.uiPageIterator_.getCurrentPageData();
        }
        return new ArrayList();
    }

    public List<String> getChecked() {
        ArrayList<String> newsletterId = new ArrayList<String>();
        UIFormCheckBoxInput checkbox = null;
        for (UIComponent component : this.getChildren()) {
            try {
                checkbox = (UIFormCheckBoxInput)component;
                if (!checkbox.isChecked()) continue;
                newsletterId.add(checkbox.getName());
            }
            catch (Exception e) {}
        }
        return newsletterId;
    }

    public NewsletterSubscriptionConfig getSubscriptionConfig() {
        return this.subscriptionConfig;
    }

    public void setSubscriptionConfig(NewsletterSubscriptionConfig subscriptionConfig) {
        this.subscriptionConfig = subscriptionConfig;
    }

    public NewsletterCategoryConfig getCategoryConfig() {
        return this.categoryConfig;
    }

    public void setCategoryConfig(NewsletterCategoryConfig categoryConfig) {
        this.categoryConfig = categoryConfig;
    }

    static /* synthetic */ NewsletterCategoryConfig access$000(UINewsletterEntryManager x0) {
        return x0.categoryConfig;
    }

    static /* synthetic */ NewsletterSubscriptionConfig access$100(UINewsletterEntryManager x0) {
        return x0.subscriptionConfig;
    }

    static /* synthetic */ NewsletterEntryHandler access$200(UINewsletterEntryManager x0) {
        return x0.newsletterEntryHandler;
    }
}

