/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.config.NewsletterUserConfig;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterManageUserHandler {
    private static final Log LOG = ExoLogger.getLogger((String)NewsletterManageUserHandler.class.getName());
    private RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
    private String workspace;

    @Deprecated
    public NewsletterManageUserHandler(String repository, String workspace) {
        this.workspace = workspace;
    }

    public NewsletterManageUserHandler(String workspace) {
        this.workspace = workspace;
    }

    private NewsletterUserConfig getUserFromNode(Node userNode) throws Exception {
        NewsletterUserConfig user = new NewsletterUserConfig();
        user.setMail(userNode.getProperty("exo:newsletterUserMail").getString());
        user.setBanned(userNode.getProperty("exo:newsletterUserBanned").getBoolean());
        return user;
    }

    private List<String> convertValuesToArray(Value[] values) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Value value : values) {
            try {
                listString.add(value.getString());
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"Error when convert values to array: ", (Throwable)e);
            }
        }
        return listString;
    }

    public List<String> getAllAdministrator(SessionProvider sessionProvider, String portalName) {
        block3: {
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                Node categoriesNode = (Node)session.getItem(NewsletterConstant.generateCategoryPath(portalName));
                if (categoriesNode.hasProperty("exo:newsletteraddministrator")) {
                    return this.convertValuesToArray(categoriesNode.getProperty("exo:newsletteraddministrator").getValues());
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"getAllAdministrator() failed because of ", (Throwable)ex);
            }
        }
        return new ArrayList<String>();
    }

    public void addAdministrator(SessionProvider sessionProvider, String portalName, String userId) throws Exception {
        block7: {
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                Node categoriesNode = (Node)session.getItem(NewsletterConstant.generateCategoryPath(portalName));
                ArrayList<String> listUsers = new ArrayList<String>();
                if (categoriesNode.hasProperty("exo:newsletteraddministrator")) {
                    listUsers.addAll(this.convertValuesToArray(categoriesNode.getProperty("exo:newsletteraddministrator").getValues()));
                }
                if (listUsers.contains(userId)) {
                    return;
                }
                listUsers.add(userId);
                categoriesNode.setProperty("exo:newsletteraddministrator", listUsers.toArray(new String[0]));
                String[] permissions = new String[]{"add_node", "set_property", "remove"};
                NodeIterator iterator = categoriesNode.getNodes();
                while (iterator.hasNext()) {
                    Node categoryNode = iterator.nextNode();
                    ExtendedNode extendedCategoryNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode);
                    if (extendedCategoryNode.canAddMixin("exo:privilegeable") || extendedCategoryNode.isNodeType("exo:privilegeable")) {
                        if (extendedCategoryNode.canAddMixin("exo:privilegeable")) {
                            extendedCategoryNode.addMixin("exo:privilegeable");
                        }
                        extendedCategoryNode.setPermission(userId, permissions);
                    }
                    NewsletterConstant.addPermissionsFromCateToSubs(categoryNode, new String[]{userId}, permissions);
                }
                session.save();
            }
            catch (Exception ex) {
                if (!LOG.isInfoEnabled()) break block7;
                LOG.info((Object)"Add administrator for newsletter failed because of ", (Throwable)ex);
            }
        }
    }

    public void deleteUserAddministrator(SessionProvider sessionProvider, String portalName, String userId) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        Node categoriesNode = (Node)session.getItem(NewsletterConstant.generateCategoryPath(portalName));
        ArrayList<String> listUsers = new ArrayList<String>();
        if (categoriesNode.hasProperty("exo:newsletteraddministrator")) {
            listUsers.addAll(this.convertValuesToArray(categoriesNode.getProperty("exo:newsletteraddministrator").getValues()));
        }
        listUsers.remove(userId);
        categoriesNode.setProperty("exo:newsletteraddministrator", listUsers.toArray(new String[0]));
        session.save();
    }

    public Node add(SessionProvider sessionProvider, String portalName, String userMail) throws Exception {
        Node userNode;
        block4: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Trying to add user " + userMail));
            }
            userNode = null;
            Session session = null;
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                session = sessionProvider.getSession(this.workspace, manageableRepository);
                String userPath = NewsletterConstant.generateUserPath(portalName);
                Node userFolderNode = (Node)session.getItem(userPath);
                userNode = userFolderNode.addNode(userMail, "exo:newsletterUser");
                userNode.setProperty("exo:newsletterUserMail", userMail);
                userNode.setProperty("exo:newsletterUserBanned", false);
                userNode.setProperty("exo:newsletterUserValidationCode", "PublicUser" + IdGenerator.generate());
                userNode.setProperty("exo:newsletterUserConfirm", false);
                session.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)("Add user " + userMail + " failed because of "), (Throwable)e);
            }
        }
        if (userNode == null) {
            throw new Exception("Can not add new user");
        }
        return userNode;
    }

    private Node getUserNodeByEmail(SessionProvider sessionProvider, String portalName, String userMail) throws Exception {
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String userPath = NewsletterConstant.generateUserPath(portalName);
            Node userFolderNode = (Node)session.getItem(userPath);
            return userFolderNode.getNode(userMail);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void changeBanStatus(SessionProvider sessionProvider, String portalName, String userMail, boolean isBanClicked) {
        block4: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Trying to ban/unban user " + userMail));
            }
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                Node userNode = this.getUserNodeByEmail(sessionProvider, portalName, userMail);
                if (userNode.getProperty("exo:newsletterUserBanned").getBoolean() == isBanClicked) {
                    return;
                }
                userNode.setProperty("exo:newsletterUserBanned", !userNode.getProperty("exo:newsletterUserBanned").getBoolean());
                session.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)("Ban/UnBan user " + userMail + " failed because of "), (Throwable)e);
            }
        }
    }

    public void delete(SessionProvider sessionProvider, String portalName, String userMail) {
        block5: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Trying to delete user " + userMail));
            }
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                String userPath = NewsletterConstant.generateUserPath(portalName);
                Node userFolderNode = (Node)session.getItem(userPath);
                Node userNode = userFolderNode.getNode(userMail);
                userNode.remove();
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                String sqlQuery = "select * from exo:newsletterSubscription where exo:newsletterSubscribedUser like '%" + userMail + "%'";
                Query query = queryManager.createQuery(sqlQuery, "sql");
                QueryResult queryResult = query.execute();
                NodeIterator nodeIterator = queryResult.getNodes();
                while (nodeIterator.hasNext()) {
                    Node subscriptionNode = nodeIterator.nextNode();
                    if (!subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) continue;
                    Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                    List<Value> oldSubscribedUsers = Arrays.asList(subscribedUserProperty.getValues());
                    ArrayList<Value> newSubscribedUsers = new ArrayList<Value>();
                    for (Value value : oldSubscribedUsers) {
                        String subscribedUserMail = value.getString();
                        if (userMail.equals(subscribedUserMail)) continue;
                        newSubscribedUsers.add(value);
                    }
                    subscribedUserProperty.setValue(newSubscribedUsers.toArray(new Value[newSubscribedUsers.size()]));
                }
                session.save();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)("Delete user " + userMail + " failed because of "), (Throwable)e);
            }
        }
    }

    public List<NewsletterUserConfig> getUsers(SessionProvider sessionProvider, String portalName, String categoryName, String subscriptionName) throws Exception {
        ArrayList<NewsletterUserConfig> listUsers = new ArrayList<NewsletterUserConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String userPath = NewsletterConstant.generateUserPath(portalName);
        Node userHomeNode = (Node)session.getItem(userPath);
        if (categoryName == null && subscriptionName == null) {
            NodeIterator nodeIterator = userHomeNode.getNodes();
            while (nodeIterator.hasNext()) {
                listUsers.add(this.getUserFromNode(nodeIterator.nextNode()));
            }
        } else {
            List<Object> listEmail = new ArrayList();
            if (categoryName != null && subscriptionName == null) {
                Node categoryNode = (Node)session.getItem(NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName);
                NodeIterator nodeIterator = categoryNode.getNodes();
                while (nodeIterator.hasNext()) {
                    Value[] subscribedUserValues;
                    Node subscriptionNode = nodeIterator.nextNode();
                    if (!subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) continue;
                    Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                    for (Value value : subscribedUserValues = subscribedUserProperty.getValues()) {
                        if (listEmail.contains(value.getString())) continue;
                        listEmail.add(value.getString());
                    }
                }
            } else {
                listEmail = this.getUsersBySubscription(sessionProvider, portalName, categoryName, subscriptionName);
            }
            for (String string : listEmail) {
                listUsers.add(this.getUserFromNode(userHomeNode.getNode(string)));
            }
        }
        return listUsers;
    }

    private List<String> getUsersBySubscription(SessionProvider sessionProvider, String portalName, String categoryName, String subscriptionName) {
        ArrayList<String> subscribedUsers;
        block5: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Trying to get list user by subscription " + portalName + "/" + categoryName + "/" + subscriptionName));
            }
            subscribedUsers = new ArrayList<String>();
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                String subscriptionPath = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subscriptionName;
                Node subscriptionNode = (Node)Node.class.cast(session.getItem(subscriptionPath));
                if (subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) {
                    Value[] subscribedUserValues;
                    Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                    for (Value value : subscribedUserValues = subscribedUserProperty.getValues()) {
                        subscribedUsers.add(value.getString());
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)("Get list user by subscription " + portalName + "/" + categoryName + "/" + subscriptionName + " failed because of "), (Throwable)e);
            }
        }
        return subscribedUsers;
    }

    public int getQuantityUserBySubscription(SessionProvider sessionProvider, String portalName, String categoryName, String subscriptionName) {
        int countUser;
        block4: {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Trying to get user's quantity by subscription " + portalName + "/" + categoryName + "/" + subscriptionName));
            }
            countUser = 0;
            try {
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                Session session = sessionProvider.getSession(this.workspace, manageableRepository);
                String subscriptionPath = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subscriptionName;
                Node subscriptionNode = (Node)Node.class.cast(session.getItem(subscriptionPath));
                if (subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) {
                    Property subscribedUserProperty = subscriptionNode.getProperty("exo:newsletterSubscribedUser");
                    countUser = subscribedUserProperty.getValues().length;
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)("Get user's quantity by subscription " + portalName + "/" + categoryName + "/" + subscriptionName + " failed because of "), (Throwable)e);
            }
        }
        return countUser;
    }

    public boolean checkExistedEmail(SessionProvider sessionProvider, String portalName, String email) {
        try {
            Node userNode = this.getUserNodeByEmail(sessionProvider, portalName, email);
            return userNode != null;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"checkExistedEmail() failed because of ", (Throwable)e);
            }
            return false;
        }
    }

    public boolean isAdministrator(String portalName, String userId) {
        try {
            List<String> administrators = this.getAllAdministrator(WCMCoreUtils.getSystemSessionProvider(), portalName);
            String superuser = ((UserACL)WCMCoreUtils.getService(UserACL.class)).getSuperUser();
            if (!administrators.contains(superuser)) {
                administrators.add(superuser);
            }
            return WCMCoreUtils.hasPermission((String)userId, administrators, (boolean)false);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"isAdministrator() failed because of ", (Throwable)e);
            }
            return false;
        }
    }

    public boolean isModerator(String userId, NewsletterCategoryConfig config) {
        try {
            List<String> moderators = Arrays.asList(config.getModerator().split(","));
            return WCMCoreUtils.hasPermission((String)userId, moderators, (boolean)false);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"isModerator() failed because of ", (Throwable)e);
            }
            return false;
        }
    }
}

