/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.workflow;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.jcr.RepositoryService;

public class WorkflowMoveNodeAction {
    public static void moveNode(RepositoryService repositoryService, String nodePath, String srcWorkspace, String destWorkspace, String destPath, String repository) {
        block11: {
            Session srcSession = null;
            Session destSession = null;
            if (!srcWorkspace.equals(destWorkspace)) {
                try {
                    srcSession = repositoryService.getCurrentRepository().getSystemSession(srcWorkspace);
                    destSession = repositoryService.getCurrentRepository().getSystemSession(destWorkspace);
                    Workspace workspace = destSession.getWorkspace();
                    Node srcNode = (Node)srcSession.getItem(nodePath);
                    try {
                        destSession.getItem(destPath);
                    }
                    catch (PathNotFoundException e) {
                        WorkflowMoveNodeAction.createNode(destSession, destPath);
                    }
                    workspace.clone(srcWorkspace, nodePath, destPath, true);
                    srcNode.remove();
                    srcSession.save();
                    destSession.save();
                    srcSession.logout();
                    destSession.logout();
                }
                catch (Exception e) {
                    if (srcSession != null) {
                        srcSession.logout();
                    }
                    if (destSession != null) {
                        destSession.logout();
                    }
                    break block11;
                }
            }
            Session session = null;
            try {
                session = repositoryService.getCurrentRepository().getSystemSession(srcWorkspace);
                Workspace workspace = session.getWorkspace();
                try {
                    session.getItem(destPath);
                }
                catch (PathNotFoundException e) {
                    WorkflowMoveNodeAction.createNode(session, destPath);
                    session.refresh(false);
                }
                workspace.move(nodePath, destPath);
                session.logout();
            }
            catch (Exception e) {
                if (session == null || !session.isLive()) break block11;
                session.logout();
            }
        }
    }

    private static void createNode(Session session, String uri) throws RepositoryException {
        String[] splittedName = StringUtils.split((String)uri, (String)"/");
        Node rootNode = session.getRootNode();
        for (int i = 0; i < splittedName.length - 1; ++i) {
            try {
                rootNode.getNode(splittedName[i]);
            }
            catch (PathNotFoundException exc) {
                rootNode.addNode(splittedName[i], "nt:unstructured");
                rootNode.save();
            }
            rootNode = rootNode.getNode(splittedName[i]);
        }
        session.save();
    }
}

