/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.metadata.impl.MetadataServiceImpl;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateServiceImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTypeTemplateUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)NodeTypeTemplateUpgradePlugin.class.getName());
    private TemplateService templateService_;
    private MetadataService metadataService_;

    public NodeTypeTemplateUpgradePlugin(TemplateService templateService, MetadataService metadataService, InitParams initParams) {
        super(initParams);
        this.templateService_ = templateService;
        this.metadataService_ = metadataService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        String unchangedMetadataTypes;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        String unchangedNodeTypes = PrivilegedSystemHelper.getProperty((String)"unchanged-nodetype-templates");
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedNodeTypes)) {
            unchangedNodeTypes = "";
        }
        if (StringUtils.isEmpty((String)(unchangedMetadataTypes = PrivilegedSystemHelper.getProperty((String)"unchanged-metadata-templates")))) {
            unchangedMetadataTypes = "";
        }
        try {
            HashSet<String> unchangedNodeTypeSet = new HashSet<String>();
            HashSet<String> unchangedMetadataTypeSet = new HashSet<String>();
            Set configuredNodeTypeSet = this.templateService_.getAllConfiguredNodeTypes();
            Set editedPredefinedNodeTypes = this.templateService_.getAllEditedConfiguredNodeTypes();
            List configuredMetadataTypeSet = this.metadataService_.getMetadataList();
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            ArrayList<String> removedMetadatas = new ArrayList<String>();
            for (String unchangedNodeType : unchangedNodeTypes.split(",")) {
                unchangedNodeTypeSet.add(unchangedNodeType.trim());
            }
            for (String unchangedMetadataType : unchangedMetadataTypes.split(",")) {
                unchangedMetadataTypeSet.add(unchangedMetadataType.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Node templateHomeNode = this.templateService_.getTemplatesHome(sessionProvider);
            NodeIterator iter = templateHomeNode.getNodes();
            while (iter.hasNext()) {
                Node templateNode = iter.nextNode();
                if (!configuredNodeTypeSet.contains(templateNode.getName()) || unchangedNodeTypeSet.contains(templateNode.getName()) || editedPredefinedNodeTypes.contains(templateNode.getName())) continue;
                removedNodes.add(templateNode);
            }
            for (String metadataType : configuredMetadataTypeSet) {
                if (unchangedMetadataTypeSet.contains(metadataType)) continue;
                removedMetadatas.add(metadataType);
            }
            for (Node removedNode : removedNodes) {
                try {
                    removedNode.remove();
                    templateHomeNode.save();
                }
                catch (Exception e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.error((Object)("Error in " + this.getName() + ": Can not remove old template: " + removedNode.getPath()));
                }
            }
            for (String removedMetadaNode : removedMetadatas) {
                this.metadataService_.removeMetadata(removedMetadaNode);
            }
            ((TemplateServiceImpl)this.templateService_).start();
            ((MetadataServiceImpl)this.metadataService_).start();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected error occurs when migrating node type template", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }
}

