/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ThumbnailNodeTypeUpgradePlugin
extends UpgradeProductPlugin {
    private static final String SUPER_TYPE_NT_UNSTRUCTURED = "nt:unstructured";
    private static final String SUPER_TYPE_NT_HIERARCHY_NODE = "nt:hierarchyNode";
    private static final String SUPER_TYPE_NT_FOLDER = "nt:folder";
    private static final String EXO_THUMBNAIL = "exo:thumbnail";
    private static final String EXO_THUMBNAILS = "exo:thumbnails";
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private DMSConfiguration dmsConfiguration_;
    private RepositoryService repoService_;

    public ThumbnailNodeTypeUpgradePlugin(DMSConfiguration dmsConfiguration, RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.dmsConfiguration_ = dmsConfiguration;
        this.repoService_ = repoService;
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            Session session = sessionProvider.getSession(this.dmsConfiguration_.getConfig().getSystemWorkspace(), this.repoService_.getCurrentRepository());
            ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)session.getWorkspace().getNodeTypeManager();
            NodeTypeValue exoThumbnailsNodeTypeValue = nodeTypeManager.getNodeTypeValue(EXO_THUMBNAILS);
            this.updateSuperType(nodeTypeManager, exoThumbnailsNodeTypeValue);
            NodeTypeValue exoThumbnailNodeTypeValue = nodeTypeManager.getNodeTypeValue(EXO_THUMBNAIL);
            this.updateSuperType(nodeTypeManager, exoThumbnailNodeTypeValue);
            this.log.info((Object)("End " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        catch (Exception e) {
            this.log.error((Object)(((Object)((Object)this)).getClass().getName() + " failed:"), (Throwable)e);
        }
    }

    private void updateSuperType(ExtendedNodeTypeManager nodeTypeManager, NodeTypeValue exoThumbnailNodeTypeValue) throws RepositoryException {
        List lstDeclaredSupertype = exoThumbnailNodeTypeValue.getDeclaredSupertypeNames();
        if (lstDeclaredSupertype.contains(SUPER_TYPE_NT_FOLDER)) {
            lstDeclaredSupertype.remove(SUPER_TYPE_NT_FOLDER);
        }
        if (!lstDeclaredSupertype.contains(SUPER_TYPE_NT_HIERARCHY_NODE)) {
            lstDeclaredSupertype.add(SUPER_TYPE_NT_HIERARCHY_NODE);
        }
        if (!lstDeclaredSupertype.contains(SUPER_TYPE_NT_UNSTRUCTURED)) {
            lstDeclaredSupertype.add(SUPER_TYPE_NT_UNSTRUCTURED);
        }
        exoThumbnailNodeTypeValue.setDeclaredSupertypeNames(lstDeclaredSupertype);
        nodeTypeManager.registerNodeType(exoThumbnailNodeTypeValue, 4);
    }
}

