/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.SerializerFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;
import sun.misc.BASE64Encoder;

public class Response {
    private String faultString;
    private int faultCode;
    private boolean isFault;
    private Object respData;
    private Namespace ns;

    public Response() {
    }

    public Response(Object response) {
        this.setResponse(response);
    }

    public Response(int faultCode, String faultString) {
        this.setErrorResponse(faultCode, faultString);
    }

    public Response(Element elem) {
        this.parse(elem);
    }

    public void parse(Element elem) {
        this.faultString = null;
        this.faultCode = 0;
        this.isFault = false;
        this.respData = null;
        this.ns = elem.getNamespace();
        Element firstElem = elem.getChild("fault", this.ns);
        if (firstElem != null) {
            this.isFault = true;
            Element fault = firstElem.getChild("value", this.ns).getChild("struct", this.ns);
            this.respData = SerializerFactory.deserialize(fault);
            this.faultCode = (Integer)((HashMap)this.respData).get("faultCode");
            this.faultString = (String)((HashMap)this.respData).get("faultString");
            return;
        }
        firstElem = elem.getChild("params", this.ns);
        if (firstElem == null) {
            return;
        }
        if ((firstElem = firstElem.getChild("param", this.ns)) == null) {
            return;
        }
        if ((firstElem = firstElem.getChild("value", this.ns)) == null) {
            return;
        }
        Element data = (Element)firstElem.getChildren().get(0);
        this.respData = SerializerFactory.deserialize(data);
    }

    public void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public boolean isFault() {
        return this.isFault;
    }

    public int getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public Object getResponse() {
        return this.respData;
    }

    public void setResponse(Object respData) {
        this.respData = respData;
        this.isFault = false;
        this.faultCode = 0;
        this.faultString = null;
    }

    public void setErrorResponse(int faultCode, String faultString) {
        this.isFault = true;
        this.respData = null;
        this.faultCode = faultCode;
        this.faultString = faultString;
        HashMap<String, Object> faultMap = new HashMap<String, Object>();
        faultMap.put("faultCode", new Integer(faultCode));
        faultMap.put("faultString", faultString);
        this.respData = faultMap;
    }

    public Element getDOM() {
        Element resp;
        Element root = new Element("methodResponse", this.ns);
        if (this.isFault()) {
            resp = new Element("fault", this.ns);
            root.addContent(resp);
        } else {
            Element params = new Element("params", this.ns);
            resp = new Element("param", this.ns);
            params.addContent(resp);
            root.addContent(params);
        }
        Element value = new Element("value", this.ns);
        resp.addContent(value);
        Element data = SerializerFactory.serialize(this.respData, this.ns);
        value.addContent(data);
        return root;
    }

    public String toString() {
        Element dom = this.getDOM();
        XMLOutputter xos = new XMLOutputter();
        return xos.outputString(dom);
    }

    public static void main(String[] args) {
        BASE64Encoder base64 = new BASE64Encoder();
        Response response = new Response();
        int errorCode = 4;
        String faultString = "Too many parameters";
        HashMap map = new HashMap();
        response.setErrorResponse(errorCode, faultString);
        System.out.println("Error Response: " + response);
        System.out.println("Is Error: " + response.isFault());
        map.put("faultCode", new Integer(4));
        map.put("faultString", "Too many parameters.");
        map.put("double", new Double(3.84839488888888E14));
        map.put("boolean", new Boolean(true));
        map.put("date", new Date());
        map.put("base64", new String("testing 1 2 3").getBytes());
        ArrayList list = new ArrayList();
        list.add(new Integer(4));
        list.add("array string");
        map.put("array", list);
        response.setResponse(map);
        System.out.println("Response: " + response);
        try {
            System.out.println("Is Fault: " + response.isFault());
            map = (HashMap)response.getResponse();
            System.out.println("FaultCode: " + map.get("faultCode"));
            System.out.println("FaultString: " + map.get("faultString"));
            System.out.println("Boolean: " + map.get("boolean"));
            System.out.println("Double: " + map.get("double"));
            System.out.println("Date: " + map.get("date"));
            System.out.println("Array: ");
            list = (ArrayList)map.get("array");
            int i = 0;
            while (i < list.size()) {
                System.out.println("   Index " + i + ": " + list.get(i));
                ++i;
            }
            System.out.println("Base64: " + new String((byte[])map.get("base64")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

