/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util;

import com.echomine.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.oro.text.perl.Perl5Util;

public class HTTPHeader {
    private HashMap headers;
    private Perl5Util httpHeaderRE = new Perl5Util();

    public HTTPHeader() {
        this.headers = new HashMap();
    }

    public void clear() {
        this.headers.clear();
    }

    public String toString() {
        return this.getHeadersAsString();
    }

    public String getHeadersAsString() {
        StringBuffer buffer = new StringBuffer(200);
        Iterator iter = this.getHeaderNames().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            buffer.append(name).append(": ");
            String value = (String)this.headers.get(name);
            buffer.append(value).append("\r\n");
        }
        return buffer.toString();
    }

    public Collection getHeaderNames() {
        return this.headers.keySet();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void parseHeaders(InputStream is) throws IOException {
        int bytesread;
        int SOCKETBUF = 1024;
        byte[] bytebuf = new byte[SOCKETBUF];
        while ((bytesread = IOUtil.readToCRLF(is, bytebuf, 0, SOCKETBUF)) != 0) {
            String line = new String(bytebuf, 0, bytesread);
            if (!this.httpHeaderRE.match("m#^(\\S+):\\s*(.+)#i", line)) continue;
            this.headers.put(this.httpHeaderRE.group(1), this.httpHeaderRE.group(2));
        }
    }
}

