/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JabberConnection;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberPresenceMessage;

public class JabberPresenceService {
    private JabberConnection connection;
    private JabberContext context;

    public JabberPresenceService(JabberConnection connection, JabberContext context) {
        this.connection = connection;
        this.context = context;
    }

    public void setToAvailable(String showState, String status) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("available");
        msg.setPriority("1");
        if (showState != null) {
            msg.setShowState(showState);
        }
        if (status != null) {
            msg.setStatus(status);
        } else {
            msg.setStatus("Online");
        }
        this.connection.send(msg);
    }

    public void setToUnavailable() throws SendMessageFailedException {
        this.connection.send(new JabberPresenceMessage("unavailable"));
    }

    public void subscribe(String jid) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("subscribe");
        msg.setTo(jid);
        this.connection.send(msg);
    }

    public void unsubscribe(String jid) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("unsubscribe");
        msg.setTo(jid);
        this.connection.send(msg);
    }

    public void sendSubscribed(String jid) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("subscribed");
        msg.setTo(jid);
        this.connection.send(msg);
    }

    public void sendUnsubscribed(String jid) throws SendMessageFailedException {
        JabberPresenceMessage msg = new JabberPresenceMessage("unsubscribed");
        msg.setTo(jid);
        this.connection.send(msg);
    }

    public void acceptSubscribe(JabberPresenceMessage msg) throws SendMessageFailedException {
        JabberPresenceMessage reply = new JabberPresenceMessage("subscribed");
        reply.setTo(msg.getFrom());
        this.connection.send(reply);
    }

    public void denySubscribe(JabberPresenceMessage msg) throws SendMessageFailedException {
        JabberPresenceMessage reply = new JabberPresenceMessage("unsubscribed");
        reply.setTo(msg.getFrom());
        this.connection.send(reply);
    }
}

