/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.CharPointer;
import tcl.lang.Interp;
import tcl.lang.ParseResult;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclParse;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.TclToken;

class ParseAdaptor {
    ParseAdaptor() {
    }

    static ParseResult parseVar(Interp interp, String string, int n, int n2) throws TclException {
        ParseResult parseResult = Parser.parseVar(interp, string.substring(--n, n2));
        parseResult.nextIndex += n;
        return parseResult;
    }

    static ParseResult parseNestedCmd(Interp interp, String string, int n, int n2) throws TclException {
        CharPointer charPointer = new CharPointer(string);
        charPointer.index = n;
        interp.evalFlags |= 1;
        Parser.eval2(interp, charPointer.array, charPointer.index, n2 - n, 0);
        TclObject tclObject = interp.getResult();
        tclObject.preserve();
        return new ParseResult(tclObject, n + interp.termOffset + 1);
    }

    static ParseResult parseQuotes(Interp interp, String string, int n, int n2) throws TclException {
        TclObject tclObject;
        CharPointer charPointer;
        TclParse tclParse = null;
        try {
            charPointer = new CharPointer(string);
            charPointer.index = n;
            tclParse = new TclParse(interp, charPointer.array, n2, null, 0);
            tclParse.commandStart = charPointer.index;
            TclToken tclToken = tclParse.getToken(0);
            tclToken.type = 1;
            tclToken.script_array = charPointer.array;
            tclToken.script_index = charPointer.index;
            ++tclParse.numTokens;
            ++tclParse.numWords;
            tclParse = Parser.parseTokens(charPointer.array, charPointer.index, 8, tclParse);
            if (charPointer.array[tclParse.termIndex] != '\"') {
                throw new TclException(interp, "missing \"");
            }
            charPointer.index = tclParse.termIndex + 1;
            tclToken = tclParse.getToken(0);
            tclToken.size = charPointer.index - tclToken.script_index;
            tclToken.numComponents = tclParse.numTokens - 1;
            if (tclToken.numComponents == 1 && tclParse.getToken((int)1).type == 4) {
                tclToken.type = 2;
            }
            tclParse.commandSize = charPointer.index - tclParse.commandStart;
            if (tclParse.numTokens <= 0) {
                throw new TclRuntimeError("parseQuotes error: null obj result");
            }
            tclObject = Parser.evalTokens(interp, tclParse.tokenList, 1, tclParse.numTokens - 1);
            Object var10_8 = null;
            tclParse.release();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            tclParse.release();
            throw throwable;
        }
        return new ParseResult(tclObject, charPointer.index);
    }

    static ParseResult parseBraces(Interp interp, String string, int n, int n2) throws TclException {
        char[] cArray = string.toCharArray();
        int n3 = 1;
        int n4 = n;
        while (n4 < n2) {
            if (Parser.charType(cArray[n4]) == '\u0000') {
                ++n4;
                continue;
            }
            if (cArray[n4] == '}') {
                if (--n3 == 0) {
                    string = new String(cArray, n, n4 - n);
                    return new ParseResult(TclString.newInstance(string), n4 + 1);
                }
                ++n4;
                continue;
            }
            if (cArray[n4] == '{') {
                ++n3;
                ++n4;
                continue;
            }
            if (cArray[n4] == '\\') {
                BackSlashResult backSlashResult = Parser.backslash(cArray, n4);
                n4 = backSlashResult.nextIndex;
                continue;
            }
            ++n4;
        }
        throw new TclException(interp, "missing close-brace");
    }
}

