/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberMessageReplyEvent;
import com.echomine.jabber.JabberMessageReplyHandler;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.MessageID;
import java.util.HashMap;

public abstract class JabberMessage {
    private JabberMessage replymsg;
    private JabberMessageReplyHandler replyHandler;
    private String messageID = MessageID.nextID();
    private boolean replyRequired = false;
    private boolean sync = false;
    private HashMap xMsgs;
    private long timeout = 30000L;
    private boolean sendXMsgs = true;

    public void interrupt() {
        if (this.sync) {
            JabberMessage jabberMessage = this;
            synchronized (jabberMessage) {
                try {
                    this.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    throw throwable;
                }
            }
        }
    }

    public void setTimeout(long ms) {
        this.timeout = ms;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isReplyRequired() {
        return this.replyRequired;
    }

    public boolean isSynchronized() {
        return this.sync;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public JabberMessage getReplyMessage() {
        return this.replymsg;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public void setMessageReplyHandler(JabberMessageReplyHandler replyHandler) {
        this.replyHandler = replyHandler;
        this.setReplyRequired(true);
    }

    public void setReplyRequired(boolean replyRequired) {
        this.replyRequired = replyRequired;
        if (!replyRequired) {
            this.sync = false;
        }
    }

    public void setSynchronized(boolean sync) {
        this.sync = sync;
        if (sync) {
            this.replyRequired = true;
        }
    }

    public JabberMessage replyReceived(JabberSession session, JabberMessage replymsg) {
        this.replymsg = replymsg;
        JabberMessageReplyEvent event = new JabberMessageReplyEvent(session, this);
        if (this.replyHandler != null) {
            this.replyHandler.replyReceived(event, replymsg);
        }
        if (this.sync) {
            JabberMessage jabberMessage = this;
            synchronized (jabberMessage) {
                try {
                    this.notifyAll();
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    throw throwable;
                }
            }
        }
        return replymsg;
    }

    public HashMap getXMessages() {
        return this.xMsgs;
    }

    public JabberMessage getXMessage(String ns) {
        if (this.xMsgs == null) {
            return null;
        }
        return (JabberMessage)this.xMsgs.get(ns);
    }

    public void setXMessage(String ns, JabberMessage msg) {
        if (this.xMsgs == null) {
            this.xMsgs = new HashMap();
        }
        this.xMsgs.put(ns, msg);
    }

    public void setXMessages(HashMap xmsgs) {
        this.xMsgs = xmsgs;
    }

    public void setSendXMessages(boolean sendXMsgs) {
        this.sendXMsgs = sendXMsgs;
    }

    public boolean isSendXMessages() {
        return this.sendXMsgs;
    }

    public abstract int getMessageType();

    public abstract String encode() throws ParseException;
}

