/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import org.exolab.javasource.JClass;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public class JConstructor {
    private JModifiers modifiers = null;
    private JNamedMap params = null;
    private JClass declaringClass = null;
    private JSourceCode sourceCode = null;

    protected JConstructor(JClass declaringClass) {
        this.declaringClass = declaringClass;
        this.modifiers = new JModifiers();
        this.params = new JNamedMap();
        this.sourceCode = new JSourceCode();
    }

    public void addParameter(JParameter parameter) throws IllegalArgumentException {
        JType jType;
        if (parameter == null) {
            return;
        }
        if (this.params.get(parameter.getName()) != null) {
            StringBuffer err = new StringBuffer();
            err.append("A parameter already exists for the constructor, ");
            err.append(this.declaringClass.getName());
            err.append(", with the name: ");
            err.append(parameter.getName());
            throw new IllegalArgumentException(err.toString());
        }
        this.params.put(parameter.getName(), parameter);
        if (this.declaringClass != null && !(jType = parameter.getType()).isPrimitive()) {
            this.declaringClass.addImport(jType.getName());
        }
    }

    public JClass getDeclaringClass() {
        return this.declaringClass;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public JParameter[] getParameters() {
        JParameter[] jpArray = new JParameter[this.params.size()];
        int i = 0;
        while (i < jpArray.length) {
            jpArray[i] = (JParameter)this.params.get(i);
            ++i;
        }
        return jpArray;
    }

    public JSourceCode getSourceCode() {
        return this.sourceCode;
    }

    public void print(JSourceWriter jsw) {
        if (this.modifiers.isPrivate()) {
            jsw.write("private");
        } else if (this.modifiers.isProtected()) {
            jsw.write("protected");
        } else {
            jsw.write("public");
        }
        jsw.write(32);
        jsw.write(this.declaringClass.getLocalName());
        jsw.write(40);
        int i = 0;
        while (i < this.params.size()) {
            if (i > 0) {
                jsw.write(", ");
            }
            jsw.write(this.params.get(i));
            ++i;
        }
        jsw.writeln(") {");
        this.sourceCode.print(jsw);
        if (!jsw.isNewline()) {
            jsw.writeln();
        }
        jsw.write("} //-- ");
        jsw.writeln(this.toString());
    }

    public void setModifiers(JModifiers modifiers) {
        this.modifiers = modifiers.copy();
        this.modifiers.setFinal(false);
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = new JSourceCode(sourceCode);
    }

    public void setSourceCode(JSourceCode sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.declaringClass.getName());
        sb.append('(');
        int i = 0;
        while (i < this.params.size()) {
            JParameter jp = (JParameter)this.params.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(jp.getType().getName());
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }
}

