/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.AuthIQMessage;
import com.echomine.jabber.GatewayIQMessage;
import com.echomine.jabber.JabberConnection;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.JabberMessageException;
import com.echomine.jabber.RegisterIQMessage;
import java.util.HashMap;

public class JabberUserService {
    private JabberConnection connection;
    private JabberContext context;

    public JabberUserService(JabberConnection connection, JabberContext context) {
        this.connection = connection;
        this.context = context;
    }

    public int login() throws JabberMessageException, SendMessageFailedException {
        AuthIQMessage msg = AuthIQMessage.createGetAuthMethodsMessage(this.context);
        this.connection.send(msg);
        int authType = msg.getMostSecureAuth();
        String zerokToken = msg.getZerokToken();
        int zerokSeq = msg.getZerokSeq();
        msg = AuthIQMessage.createLoginMessage(this.context, authType, zerokToken, zerokSeq);
        this.connection.send(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
        if (zerokToken != null && zerokSeq <= 3) {
            this.changePassword(this.context.getPassword());
        }
        return authType;
    }

    public void register(String serviceJID, HashMap fields) throws JabberMessageException, SendMessageFailedException {
        RegisterIQMessage msg = new RegisterIQMessage("set");
        msg.setTo(serviceJID);
        msg.setSynchronized(true);
        msg.addFields(fields);
        this.connection.send(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
    }

    public void changePassword(String newPassword) throws JabberMessageException, SendMessageFailedException {
        RegisterIQMessage msg = new RegisterIQMessage("set");
        msg.setTo(this.context.getServerName());
        msg.addField("username", this.context.getUsername());
        msg.addField("password", newPassword);
        msg.setSynchronized(true);
        this.connection.send(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
    }

    public HashMap getRegisterFields(String serviceJID) throws JabberMessageException, SendMessageFailedException {
        RegisterIQMessage msg = new RegisterIQMessage("get");
        msg.setTo(serviceJID);
        msg.setSynchronized(true);
        this.connection.send(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
        return ((RegisterIQMessage)msg.getReplyMessage()).getFields();
    }

    public void removeRegisterService(String serviceJID, String key) throws JabberMessageException, SendMessageFailedException {
        RegisterIQMessage msg = new RegisterIQMessage("set");
        msg.setTo(serviceJID);
        msg.addField("key", key);
        msg.addField("remove", null);
        msg.setSynchronized(true);
        this.connection.send(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
    }

    public String translateUserToJID(String serviceJID, String user) throws JabberMessageException, SendMessageFailedException {
        GatewayIQMessage msg = new GatewayIQMessage("set");
        msg.setTo(serviceJID);
        msg.setSynchronized(true);
        msg.addField("prompt", user);
        this.connection.send(msg);
        if (msg.isError()) {
            throw new JabberMessageException(msg.getErrorMessage());
        }
        GatewayIQMessage reply = (GatewayIQMessage)msg.getReplyMessage();
        return (String)reply.getFields().get("prompt");
    }
}

