/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSByte
extends XSPatternBase {
    Byte maxInclusive = null;
    Byte maxExclusive = null;
    Byte minInclusive = null;
    Byte minExclusive = null;
    private static JType jType = JType.Byte;
    private boolean _asWrapper = false;

    public XSByte() {
        this(SourceGenerator.usePrimitiveWrapper());
    }

    public XSByte(boolean asWrapper) {
        super((short)38);
        this._asWrapper = asWrapper;
        jType = this._asWrapper ? new JClass("java.lang.Byte") : JType.Byte;
    }

    public JType getJType() {
        return jType;
    }

    public Byte getMaxExclusive() {
        return this.maxExclusive;
    }

    public Byte getMaxInclusive() {
        return this.maxInclusive;
    }

    public Byte getMinExclusive() {
        return this.minExclusive;
    }

    public Byte getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(byte max) {
        this.maxExclusive = new Byte(max);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Byte max) {
        this.maxExclusive = max;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(byte max) {
        this.maxInclusive = new Byte(max);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Byte max) {
        this.maxInclusive = max;
        this.maxExclusive = null;
    }

    public void setMinExclusive(byte min) {
        this.minExclusive = new Byte(min);
        this.minInclusive = null;
    }

    public void setMinExclusive(Byte min) {
        this.minExclusive = min;
        this.minInclusive = null;
    }

    public void setMinInclusive(byte min) {
        this.minInclusive = new Byte(min);
        this.minExclusive = null;
    }

    public void setMinInclusive(Byte min) {
        this.minInclusive = min;
        this.minExclusive = null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSType.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toByte());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toByte());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toByte());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toByte());
                continue;
            }
            if (!"pattern".equals(name)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (SourceGenerator.usePrimitiveWrapper()) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("new Byte(");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((Byte)");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".byteValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        String pattern;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("ByteValidator typeValidator = new ByteValidator();");
        if (this.hasMinimum()) {
            Byte min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(");
            }
            jsc.append("(byte)");
            jsc.append(min.toString());
            jsc.append(");");
        }
        if (this.hasMaximum()) {
            Byte max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(");
            }
            jsc.append("(byte)");
            jsc.append(max.toString());
            jsc.append(");");
        }
        if (fixedValue != null) {
            Byte.parseByte(fixedValue);
            jsc.add("typeValidator.setFixed(");
            jsc.append("(byte)");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        if ((pattern = this.getPattern()) != null) {
            jsc.add("typeValidator.setPattern(\"");
            jsc.append(XSType.escapePattern(pattern));
            jsc.append("\");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

