/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.Util;

public class TclDouble
extends InternalRep {
    private double value;

    private TclDouble(double d) {
        this.value = d;
    }

    private TclDouble(Interp interp, String string) throws TclException {
        this.value = Util.getDouble(interp, string);
    }

    protected InternalRep duplicate() {
        return new TclDouble(this.value);
    }

    public static TclObject newInstance(double d) {
        return new TclObject(new TclDouble(d));
    }

    private static void setDoubleFromAny(Interp interp, TclObject tclObject) throws TclException {
        InternalRep internalRep = tclObject.getInternalRep();
        if (!(internalRep instanceof TclDouble)) {
            if (internalRep instanceof TclBoolean) {
                boolean bl = TclBoolean.get(interp, tclObject);
                if (bl) {
                    tclObject.setInternalRep(new TclDouble(1.0));
                } else {
                    tclObject.setInternalRep(new TclDouble(0.0));
                }
            } else if (internalRep instanceof TclInteger) {
                int n = TclInteger.get(interp, tclObject);
                tclObject.setInternalRep(new TclDouble(n));
            } else {
                tclObject.setInternalRep(new TclDouble(interp, tclObject.toString()));
            }
        }
    }

    public static double get(Interp interp, TclObject tclObject) throws TclException {
        TclDouble tclDouble;
        InternalRep internalRep = tclObject.getInternalRep();
        if (!(internalRep instanceof TclDouble)) {
            TclDouble.setDoubleFromAny(interp, tclObject);
            tclDouble = (TclDouble)tclObject.getInternalRep();
        } else {
            tclDouble = (TclDouble)internalRep;
        }
        return tclDouble.value;
    }

    public static void set(TclObject tclObject, double d) {
        tclObject.invalidateStringRep();
        InternalRep internalRep = tclObject.getInternalRep();
        if (internalRep instanceof TclDouble) {
            TclDouble tclDouble = (TclDouble)internalRep;
            tclDouble.value = d;
        } else {
            tclObject.setInternalRep(new TclDouble(d));
        }
    }

    public String toString() {
        return Util.printDouble(this.value);
    }
}

