/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.jabber.JabberJDOMMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageHandler;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.MessageNotSupportedException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.xml.sax.Attributes;

public class JDOMMessageHandler
extends JabberMessageHandler {
    private Element rootElem;
    private Element curElem;
    private JabberMessage msg;

    public JDOMMessageHandler(JabberMessageParser msgParser) {
        super(msgParser);
    }

    public void startMessage() {
        this.curElem = null;
        this.rootElem = null;
        this.msg = null;
    }

    public void endMessage() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) {
        String prefix = "";
        if (qName.lastIndexOf(":") != -1) {
            prefix = qName.substring(0, qName.lastIndexOf(":"));
        }
        Element elem = new Element(localName, prefix, namespaceURI);
        int i = 0;
        while (i < attr.getLength()) {
            String attrQName = attr.getQName(i);
            String attrPrefix = attrQName.lastIndexOf(":") != -1 ? attrQName.substring(0, attrQName.lastIndexOf(":")) : "";
            Attribute att = new Attribute(attr.getLocalName(i), attr.getValue(i), Namespace.getNamespace((String)attrPrefix, (String)attr.getURI(i)));
            elem.setAttribute(att);
            ++i;
        }
        if (this.rootElem == null) {
            this.curElem = this.rootElem = elem;
        } else {
            this.curElem.addContent(elem);
            this.curElem = elem;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.curElem = this.curElem.getParent();
    }

    public void characters(char[] ch, int start, int length) {
        this.curElem.addContent(new String(ch, start, length));
    }

    public Element getDOM() {
        return this.rootElem;
    }

    public JabberMessage getMessage() {
        if (this.msg != null) {
            return this.msg;
        }
        try {
            this.msg = this.getMessageParser().createMessage(this.rootElem.getQualifiedName(), this.rootElem.getNamespace(), this.getDOM());
        }
        catch (MessageNotSupportedException messageNotSupportedException) {
            // empty catch block
        }
        if (this.msg == null) {
            this.msg = new JabberJDOMMessage(this.rootElem);
        }
        return this.msg;
    }
}

