/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.AbstractJabberMessage;
import com.echomine.jabber.DelayXMessage;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import com.echomine.jabber.PGPSignedXMessage;
import org.jdom.Element;

public class JabberPresenceMessage
extends AbstractJabberMessage {
    private String showState;
    private String status;
    private String priority;

    public JabberPresenceMessage(String type) {
        super(type, new Element("presence", JabberCode.XMLNS_PRESENCE));
    }

    public JabberPresenceMessage() {
        this("available");
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        super.parse(parser, msgTree);
        if (this.getType() == null) {
            this.setType("available");
        }
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
        this.getDOM().removeChild("status", JabberCode.XMLNS_PRESENCE);
        if (status != null) {
            Element temp = new Element("status", JabberCode.XMLNS_PRESENCE);
            temp.setText(status);
            this.getDOM().addContent(temp);
        }
    }

    public String getStatus() {
        if (this.status != null) {
            return this.status;
        }
        this.status = this.getDOM().getChildText("status", JabberCode.XMLNS_PRESENCE);
        return this.status;
    }

    public String getShowState() {
        if (this.showState != null) {
            return this.showState;
        }
        this.showState = this.getDOM().getChildText("show", JabberCode.XMLNS_PRESENCE);
        return this.showState;
    }

    public void setShowState(String showState) {
        this.showState = showState;
        this.getDOM().removeChild("show", JabberCode.XMLNS_PRESENCE);
        if (showState != null) {
            Element temp = new Element("show", JabberCode.XMLNS_PRESENCE);
            temp.setText(showState);
            this.getDOM().addContent(temp);
        }
    }

    public String getPriority() {
        if (this.priority != null) {
            return this.priority;
        }
        this.priority = this.getDOM().getChildText("priority", JabberCode.XMLNS_PRESENCE);
        return this.priority;
    }

    public void setPriority(String priority) {
        Integer.parseInt(priority);
        this.priority = priority;
        this.getDOM().removeChild("priority", JabberCode.XMLNS_PRESENCE);
        if (priority != null) {
            Element temp = new Element("priority", JabberCode.XMLNS_PRESENCE);
            temp.setText(priority);
            this.getDOM().addContent(temp);
        }
    }

    public int getMessageType() {
        return 2;
    }

    public DelayXMessage getDelayMessage() {
        return (DelayXMessage)this.getXMessage(JabberCode.XMLNS_X_DELAY.getURI());
    }

    public PGPSignedXMessage getPGPSignedMessage() {
        return (PGPSignedXMessage)this.getXMessage(JabberCode.XMLNS_X_PGP_SIGNED.getURI());
    }
}

