/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.lang.reflect.Array;
import tcl.lang.Command;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.JACL;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.Util;

class GlobCmd
implements Command {
    private static final char[] specCharArr = new char[]{'*', '[', ']', '?', '\\'};
    private static final String[] validOptions = new String[]{"-nocomplain", "--"};
    private static final int OPT_NOCOMPLAIN = 0;
    private static final int OPT_LAST = 1;

    GlobCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        boolean bl = false;
        int n = 1;
        String string = "";
        String string2 = "";
        boolean bl2 = false;
        while (n < tclObjectArray.length && !bl2) {
            if (!tclObjectArray[n].toString().startsWith("-")) break;
            int n2 = TclIndex.get(interp, tclObjectArray[n], validOptions, "switch", 1);
            switch (n2) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                default: {
                    throw new TclException(interp, "GlobCmd.cmdProc: bad option " + n2 + " index to validOptions");
                }
            }
            ++n;
        }
        if (n >= tclObjectArray.length) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?switches? name ?name ...?");
        }
        TclObject tclObject = TclList.newInstance();
        tclObject.preserve();
        int n3 = n;
        while (n3 < tclObjectArray.length) {
            block31: {
                String string3;
                String string4 = tclObjectArray[n3].toString();
                switch (JACL.PLATFORM) {
                    case 1: {
                        string3 = "/\\:";
                        break;
                    }
                    case 2: {
                        if (string4.indexOf(58) == -1) {
                            string3 = "/";
                            break;
                        }
                        string3 = ":";
                        break;
                    }
                    default: {
                        string3 = "/";
                    }
                }
                int n4 = 0;
                if (string4.startsWith("~")) {
                    while (n4 < string4.length()) {
                        char c = string4.charAt(n4);
                        if (c == '\\' ? string3.indexOf(string4.charAt(n4 + 1)) != -1 : string3.indexOf(c) != -1) break;
                        ++n4;
                    }
                    if (GlobCmd.strpbrk(string4.substring(1, n4).toCharArray(), specCharArr) < 0) {
                        try {
                            string = FileUtil.doTildeSubst(interp, string4.substring(1, n4));
                        }
                        catch (TclException tclException) {
                            if (bl) {
                                string = null;
                            }
                            throw new TclException(interp, tclException.getMessage());
                        }
                    } else {
                        if (!bl) {
                            throw new TclException(interp, "globbing characters not supported in user names");
                        }
                        string = null;
                    }
                    if (string == null) {
                        if (bl) {
                            interp.setResult("");
                            return;
                        }
                        return;
                    }
                    if (n4 != string4.length()) {
                        ++n4;
                    }
                }
                string2 = string4.substring(n4);
                try {
                    GlobCmd.doGlob(interp, string3, new StringBuffer(string), string2, tclObject);
                }
                catch (TclException tclException) {
                    if (bl) break block31;
                    throw new TclException(interp, tclException.getMessage());
                }
            }
            ++n3;
        }
        try {
            if (TclList.getLength(interp, tclObject) == 0 && !bl) {
                String string5 = "";
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("no files matched glob pattern");
                stringBuffer.append(tclObjectArray.length == 2 ? " \"" : "s \"");
                n3 = n;
                while (n3 < tclObjectArray.length) {
                    stringBuffer.append(string5 + tclObjectArray[n3].toString());
                    if (n3 == n) {
                        string5 = " ";
                    }
                    ++n3;
                }
                stringBuffer.append("\"");
                throw new TclException(interp, stringBuffer.toString());
            }
            if (TclList.getLength(interp, tclObject) > 0) {
                interp.setResult(tclObject);
            }
            Object var15_19 = null;
            tclObject.release();
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            tclObject.release();
            throw throwable;
        }
    }

    private static int SkipToChar(String string, int n, char c) {
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        int n4 = string.length();
        while (n3 < n4) {
            if (bl) {
                bl = false;
            } else {
                char c2 = string.charAt(n3);
                if (n2 == 0 && c2 == c) {
                    return n3;
                }
                if (c2 == '{') {
                    ++n2;
                } else if (c2 == '}') {
                    --n2;
                } else if (c2 == '\\') {
                    bl = true;
                }
            }
            ++n3;
        }
        return -1;
    }

    private static final void doGlob(Interp interp, String string, StringBuffer stringBuffer, String string2, TclObject tclObject) throws TclException {
        String string3;
        int n;
        int n2 = 0;
        int n3 = string2.length();
        int n4 = stringBuffer.length();
        char c = '\u0000';
        if (n4 > 0) {
            c = stringBuffer.charAt(n4 - 1);
        }
        String string4 = string2;
        int n5 = 0;
        while (n5 < n3) {
            n = string2.charAt(n5);
            if (n == 92 && n5 + 1 < n3 && string.indexOf(string2.charAt(n5 + 1)) != -1) {
                ++n5;
            } else if (string.indexOf(n) == -1) break;
            ++n2;
            ++n5;
        }
        switch (JACL.PLATFORM) {
            case 2: {
                if (string.charAt(0) == '/') {
                    if ((n4 != 0 || n2 != 0) && (n4 <= 0 || c == ':')) break;
                    stringBuffer.append(":");
                    break;
                }
                if (n2 == 0) {
                    if (n4 <= 0 || c == ':') break;
                    stringBuffer.append(":");
                    break;
                }
                if (c == ':') {
                    --n2;
                }
                while (n2-- > 0) {
                    stringBuffer.append(":");
                }
                break;
            }
            case 1: {
                if (string4.startsWith(":")) {
                    stringBuffer.append(":");
                    if (n2 <= 1) break;
                    stringBuffer.append("/");
                    break;
                }
                if (n5 >= n3 || (n4 <= 0 || string.indexOf(c) != -1) && (n4 != 0 || n2 <= 0)) break;
                stringBuffer.append("/");
                if (n4 != 0 || n2 <= 1) break;
                stringBuffer.append("/");
                break;
            }
            default: {
                if (n5 >= n3 || (n4 <= 0 || string.indexOf(c) != -1) && (n4 != 0 || n2 <= 0)) break;
                stringBuffer.append("/");
            }
        }
        int n6 = -1;
        int n7 = -1;
        boolean bl = false;
        int n8 = n5;
        while (n8 != n3) {
            char c2 = string2.charAt(n8);
            if (bl) {
                bl = false;
            } else if (c2 == '\\') {
                bl = true;
                if (n8 + 1 < n3 && string.indexOf(string2.charAt(n8 + 1)) != -1) {
                    break;
                }
            } else {
                if (string.indexOf(c2) != -1) break;
                if (c2 == '{') {
                    n7 = n8++;
                    n6 = GlobCmd.SkipToChar(string2, n8, '}');
                    if (n6 != -1) break;
                    throw new TclException(interp, "unmatched open-brace in file name");
                }
                if (c2 == '}') {
                    throw new TclException(interp, "unmatched close-brace in file name");
                }
            }
            ++n8;
        }
        if (n7 != -1) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(string2.substring(n5, n7));
            int n9 = stringBuffer2.length();
            n4 = stringBuffer.length();
            n8 = n7;
            while (n8 < n6) {
                if ((n = GlobCmd.SkipToChar(string2, ++n8, ',')) == -1 || n > n6) {
                    n = n6;
                }
                stringBuffer.setLength(n4);
                stringBuffer2.setLength(n9);
                stringBuffer2.append(string2.substring(n8, n));
                stringBuffer2.append(string2.substring(n6 + 1));
                n8 = n;
                GlobCmd.doGlob(interp, string, stringBuffer, stringBuffer2.toString(), tclObject);
            }
            return;
        }
        int n10 = n8 < n3 ? GlobCmd.strpbrk(string2.substring(0, n8).toCharArray(), specCharArr) : GlobCmd.strpbrk(string2.substring(n5).toCharArray(), specCharArr);
        if (n10 != -1) {
            GlobCmd.matchFiles(interp, string, stringBuffer.toString(), string2.substring(n5), n8 - n5, tclObject);
            return;
        }
        stringBuffer.append(string2.substring(n5, n8));
        if (n8 < n3) {
            GlobCmd.doGlob(interp, string, stringBuffer, string2.substring(n8), tclObject);
            return;
        }
        switch (JACL.PLATFORM) {
            case 2: {
                if (stringBuffer.toString().indexOf(58) == -1) {
                    stringBuffer.append(":");
                }
                string3 = stringBuffer.toString();
                break;
            }
            case 1: {
                if (stringBuffer.length() == 0) {
                    if (string4.length() > 1 && string4.charAt(0) == '\\' && (string4.charAt(1) == '/' || string4.charAt(1) == '\\') || string4.length() > 0 && string4.charAt(0) == '/') {
                        stringBuffer.append("\\");
                    } else {
                        stringBuffer.append(".");
                    }
                }
                string3 = stringBuffer.toString().replace('\\', '/');
                break;
            }
            default: {
                if (stringBuffer.length() == 0) {
                    if (string4.startsWith("\\/") || string4.startsWith("/")) {
                        stringBuffer.append("/");
                    } else {
                        stringBuffer.append(".");
                    }
                }
                string3 = stringBuffer.toString();
            }
        }
        GlobCmd.addFileToResult(interp, string3, string, tclObject);
    }

    private static final void matchFiles(Interp interp, String string, String string2, String string3, int n, TclObject tclObject) throws TclException {
        String[] stringArray;
        boolean bl;
        int n2;
        int n3 = n;
        int n4 = string2.length();
        int n5 = string3.length();
        StringBuffer stringBuffer = new StringBuffer();
        switch (JACL.PLATFORM) {
            case 1: {
                if (n4 == 0) {
                    stringBuffer.append("./");
                } else {
                    stringBuffer.append(string2);
                    n2 = stringBuffer.charAt(n4 - 1);
                    if (n2 == 58 && n4 == 2 || string.indexOf(n2) == -1) {
                        stringBuffer.append("/");
                    }
                }
                string3 = string3.toLowerCase();
                break;
            }
            default: {
                if (n4 == 0) {
                    stringBuffer.append(".");
                    break;
                }
                stringBuffer.append(string2);
            }
        }
        File file = GlobCmd.createAbsoluteFileObj(interp, stringBuffer.toString());
        if (!file.isDirectory()) {
            return;
        }
        if (string3.startsWith(".") || string3.startsWith("\\.")) {
            bl = true;
            stringArray = GlobCmd.addHiddenToDirList(file);
        } else {
            bl = false;
            stringArray = file.list();
        }
        if (stringArray.length == 0 && string2.endsWith("/")) {
            string2 = string2.substring(0, n4 - 1);
        }
        if (n < n5 && string3.charAt(n) == '\\') {
            ++n;
        }
        if (n < n5 - 1) {
            ++n;
        }
        n2 = 0;
        while (n2 < stringArray.length) {
            if (bl || !stringArray[n2].startsWith(".")) {
                String string4 = stringArray[n2];
                if (JACL.PLATFORM == 1) {
                    string4 = string4.toLowerCase();
                }
                if (Util.stringMatch(string4, string3.substring(0, n3))) {
                    stringBuffer.setLength(n4);
                    stringBuffer.append(stringArray[n2]);
                    if (n == string3.length()) {
                        GlobCmd.addFileToResult(interp, stringBuffer.toString(), string, tclObject);
                    } else {
                        file = GlobCmd.createAbsoluteFileObj(interp, stringBuffer.toString());
                        if (file.isDirectory()) {
                            stringBuffer.append("/");
                            GlobCmd.doGlob(interp, string, stringBuffer, string3.substring(n3 + 1), tclObject);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private static final int strpbrk(char[] cArray, char[] cArray2) {
        int n = 0;
        while (n < cArray.length) {
            int n2 = 0;
            while (n2 < cArray2.length) {
                if (cArray[n] == cArray2[n2]) {
                    return n;
                }
                ++n2;
            }
            ++n;
        }
        return -1;
    }

    private static final String[] addHiddenToDirList(File file) {
        String[] stringArray;
        String[] stringArray2 = file.list();
        int n = Array.getLength(stringArray2);
        try {
            stringArray = (String[])Array.newInstance(Class.forName("java.lang.String"), n + 2);
        }
        catch (Exception exception) {
            return stringArray2;
        }
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringArray2[n2];
            ++n2;
        }
        stringArray[n] = ".";
        stringArray[n + 1] = "..";
        return stringArray;
    }

    private static void addFileToResult(Interp interp, String string, String string2, TclObject tclObject) throws TclException {
        TclObject[] tclObjectArray;
        String string3 = string;
        int n = string.length();
        if (JACL.PLATFORM == 1 && n >= 2 && string.charAt(1) == ':') {
            if (n == 2) {
                string = string + '\\';
            } else if (string.charAt(2) != '\\') {
                string = string.substring(0, 2) + '\\' + string.substring(2);
            }
        }
        File file = FileUtil.getPathType(string = FileUtil.joinPath(interp, tclObjectArray = TclList.getElements(interp, FileUtil.splitAndTranslate(interp, string)), 0, tclObjectArray.length)) == 2 ? FileUtil.getNewFileObj(interp, string) : new File(interp.getWorkingDir(), string);
        if (n > 0 && string2.indexOf(string3.charAt(n - 1)) != -1) {
            if (file.isDirectory()) {
                TclList.append(interp, tclObject, TclString.newInstance(string3));
            }
        } else if (file.exists()) {
            TclList.append(interp, tclObject, TclString.newInstance(string3));
        }
    }

    private static final File createAbsoluteFileObj(Interp interp, String string) throws TclException {
        if (string.equals("")) {
            return interp.getWorkingDir();
        }
        if (JACL.PLATFORM == 1 && string.length() >= 2 && string.charAt(1) == ':') {
            String string2 = null;
            if (string.length() == 2) {
                string2 = string.substring(0, 2) + '\\';
            } else if (string.charAt(2) != '\\') {
                string2 = string.substring(0, 2) + '\\' + string.substring(2);
            }
            if (string2 != null) {
                return FileUtil.getNewFileObj(interp, string2);
            }
        }
        return FileUtil.getNewFileObj(interp, string);
    }
}

