/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Notifier;

public abstract class TimerHandler {
    Notifier notifier;
    long atTime;
    boolean isCancelled;
    int generation;

    public TimerHandler(Notifier notifier, int n) {
        this.atTime = System.currentTimeMillis() + (long)n;
        this.notifier = notifier;
        this.isCancelled = false;
        Notifier notifier2 = this.notifier;
        synchronized (notifier2) {
            this.generation = this.notifier.timerGeneration;
            int n2 = 0;
            while (n2 < this.notifier.timerList.size()) {
                TimerHandler timerHandler = (TimerHandler)this.notifier.timerList.elementAt(n2);
                if (this.atTime < timerHandler.atTime) break;
                ++n2;
            }
            this.notifier.timerList.insertElementAt(this, n2);
            if (Thread.currentThread() != this.notifier.primaryThread) {
                this.notifier.notifyAll();
            }
        }
    }

    public synchronized void cancel() {
        if (this.isCancelled) {
            return;
        }
        this.isCancelled = true;
        Notifier notifier = this.notifier;
        synchronized (notifier) {
            int n = 0;
            while (n < this.notifier.timerList.size()) {
                if (this.notifier.timerList.elementAt(n) == this) {
                    this.notifier.timerList.removeElementAt(n);
                    return;
                }
                ++n;
            }
        }
    }

    final synchronized int invoke() {
        if (!this.isCancelled) {
            this.processTimerEvent();
            return 1;
        }
        return 0;
    }

    public abstract void processTimerEvent();
}

