/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;

class StringCmd
implements Command {
    private static final String[] validCmds = new String[]{"compare", "first", "index", "last", "length", "match", "range", "tolower", "toupper", "trim", "trimleft", "trimright", "wordend", "wordstart"};
    private static final int OPT_COMMAND = 0;
    private static final int OPT_FIRST = 1;
    private static final int OPT_INDEX = 2;
    private static final int OPT_LAST = 3;
    private static final int OPT_LENGTH = 4;
    private static final int OPT_MATCH = 5;
    private static final int OPT_RANGE = 6;
    private static final int OPT_TOLOWER = 7;
    private static final int OPT_TOUPPER = 8;
    private static final int OPT_TRIM = 9;
    private static final int OPT_TRIMLEFT = 10;
    private static final int OPT_TRIMRIGHT = 11;
    private static final int OPT_WORDEND = 12;
    private static final int OPT_WORDSTART = 13;

    StringCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option arg ?arg ...?");
        }
        int n = TclIndex.get(interp, tclObjectArray[1], validCmds, "option", 0);
        switch (n) {
            case 0: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "compare string1 string2");
                }
                if (tclObjectArray[2] == tclObjectArray[3]) {
                    interp.setResult(0);
                    return;
                }
                int n2 = tclObjectArray[2].toString().compareTo(tclObjectArray[3].toString());
                if (n2 > 0) {
                    interp.setResult(1);
                    break;
                }
                if (n2 < 0) {
                    interp.setResult(-1);
                    break;
                }
                interp.setResult(0);
                break;
            }
            case 3: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "last string1 string2");
                }
                String string = tclObjectArray[2].toString();
                String string2 = tclObjectArray[3].toString();
                interp.setResult(string2.lastIndexOf(string));
                break;
            }
            case 1: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "first string1 string2");
                }
                String string = tclObjectArray[2].toString();
                if (string.length() == 0) {
                    interp.setResult(-1);
                    break;
                }
                String string3 = tclObjectArray[3].toString();
                interp.setResult(string3.indexOf(string));
                break;
            }
            case 2: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "index string charIndex");
                }
                int n3 = TclInteger.get(interp, tclObjectArray[3]);
                if (n3 < 0 || n3 >= tclObjectArray[2].toString().length()) {
                    interp.resetResult();
                    break;
                }
                char[] cArray = new char[]{tclObjectArray[2].toString().charAt(n3)};
                interp.setResult(new String(cArray));
                break;
            }
            case 4: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "length string");
                }
                interp.setResult(tclObjectArray[2].toString().length());
                break;
            }
            case 5: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "match pattern string");
                }
                interp.setResult(Util.stringMatch(tclObjectArray[3].toString(), tclObjectArray[2].toString()));
                break;
            }
            case 6: {
                int n4;
                if (tclObjectArray.length != 5) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "range string first last");
                }
                String string = tclObjectArray[2].toString();
                int n5 = string.length();
                int n6 = TclInteger.getForIndex(interp, tclObjectArray[3], n5 - 1);
                if (n6 < 0) {
                    n6 = 0;
                }
                if ((n4 = TclInteger.getForIndex(interp, tclObjectArray[4], n5 - 1)) >= n5) {
                    n4 = n5 - 1;
                }
                if (n6 > n4) {
                    interp.resetResult();
                    break;
                }
                interp.setResult(string.substring(n6, n4 + 1));
                break;
            }
            case 7: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "tolower string");
                }
                interp.setResult(tclObjectArray[2].toString().toLowerCase());
                break;
            }
            case 8: {
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "toupper string");
                }
                interp.setResult(tclObjectArray[2].toString().toUpperCase());
                break;
            }
            case 9: {
                if (tclObjectArray.length == 3) {
                    interp.setResult(tclObjectArray[2].toString().trim());
                    break;
                }
                if (tclObjectArray.length == 4) {
                    String string = Util.TrimLeft(tclObjectArray[2].toString(), tclObjectArray[3].toString());
                    interp.setResult(Util.TrimRight(string, tclObjectArray[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 1, tclObjectArray, "trim string ?chars?");
            }
            case 10: {
                if (tclObjectArray.length == 3) {
                    interp.setResult(Util.TrimLeft(tclObjectArray[2].toString()));
                    break;
                }
                if (tclObjectArray.length == 4) {
                    interp.setResult(Util.TrimLeft(tclObjectArray[2].toString(), tclObjectArray[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 1, tclObjectArray, "trimleft string ?chars?");
            }
            case 11: {
                if (tclObjectArray.length == 3) {
                    interp.setResult(Util.TrimRight(tclObjectArray[2].toString()));
                    break;
                }
                if (tclObjectArray.length == 4) {
                    interp.setResult(Util.TrimRight(tclObjectArray[2].toString(), tclObjectArray[3].toString()));
                    break;
                }
                throw new TclNumArgsException(interp, 1, tclObjectArray, "trimright string ?chars?");
            }
            case 12: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "wordend string index");
                }
                String string = tclObjectArray[2].toString();
                char[] cArray = string.toCharArray();
                int n7 = string.length();
                int n8 = TclInteger.get(interp, tclObjectArray[3]);
                if (n8 < 0) {
                    n8 = 0;
                }
                if (n8 > n7) {
                    interp.setResult(n7);
                    return;
                }
                int n9 = n8;
                while (n9 < n7) {
                    char c = cArray[n9];
                    if (!Util.isLetterOrDigit(c) && c != '_') break;
                    ++n9;
                }
                if (n9 == n8) {
                    n9 = n8 + 1;
                }
                interp.setResult(n9);
                break;
            }
            case 13: {
                if (tclObjectArray.length != 4) {
                    throw new TclNumArgsException(interp, 1, tclObjectArray, "wordstart string index");
                }
                String string = tclObjectArray[2].toString();
                char[] cArray = string.toCharArray();
                int n10 = string.length();
                int n11 = TclInteger.get(interp, tclObjectArray[3]);
                if (n11 > n10) {
                    n11 = n10 - 1;
                }
                if (n11 < 0) {
                    interp.setResult(0);
                    return;
                }
                int n12 = n11;
                while (n12 >= 0) {
                    char c = cArray[n12];
                    if (!Util.isLetterOrDigit(c) && c != '_') break;
                    --n12;
                }
                if (n12 != n11) {
                    ++n12;
                }
                interp.setResult(n12);
                break;
            }
            default: {
                throw new TclRuntimeError("TclIndex.get() error");
            }
        }
    }
}

