/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.jabber.JabberCode;
import java.util.ArrayList;
import java.util.Iterator;
import org.jdom.Element;

public class RosterItem {
    private String name;
    private String jid;
    private ArrayList groups = new ArrayList();
    private String subscription;
    private String ask;

    protected RosterItem() {
    }

    public RosterItem(String jid, String name) {
        this.jid = jid;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJID() {
        return this.jid;
    }

    public void setJID(String jid) {
        this.jid = jid;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public String getAsk() {
        return this.ask;
    }

    public void setAsk(String ask) {
        this.ask = ask;
    }

    public void addGroup(String name) {
        this.groups.add(name);
    }

    public void removeGroup(String name) {
        this.groups.remove(name);
    }

    public String[] getGroups() {
        String[] groupList = new String[this.groups.size()];
        this.groups.toArray(groupList);
        return groupList;
    }

    public boolean isInGroup(String name) {
        return this.groups.contains(name);
    }

    public void setRemove(boolean remove) {
        this.subscription = remove ? "remove" : null;
    }

    public Element getDOM() {
        Element elem = new Element("item", JabberCode.XMLNS_IQ_ROSTER);
        elem.setAttribute("jid", this.jid);
        if (this.name != null) {
            elem.setAttribute("name", this.name);
        }
        if (this.subscription != null) {
            elem.setAttribute("subscription", this.subscription);
        }
        Iterator iter = this.groups.iterator();
        while (iter.hasNext()) {
            Element group = new Element("group", JabberCode.XMLNS_IQ_ROSTER);
            group.setText((String)iter.next());
            elem.addContent(group);
        }
        return elem;
    }

    public static RosterItem createRosterItem(Element rosterElem) {
        RosterItem item = new RosterItem();
        item.setName(rosterElem.getAttributeValue("name"));
        item.setJID(rosterElem.getAttributeValue("jid"));
        item.setSubscription(rosterElem.getAttributeValue("subscription"));
        item.setAsk(rosterElem.getAttributeValue("ask"));
        Iterator iter = rosterElem.getChildren("group", rosterElem.getNamespace()).iterator();
        while (iter.hasNext()) {
            Element temp = (Element)iter.next();
            item.addGroup(temp.getText());
        }
        return item;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("<item jid=\"").append(this.jid).append("\" ");
        buf.append("name=\"").append(this.name).append("\" ");
        buf.append("subscription=\"").append(this.subscription).append("\" ");
        buf.append("ask=\"").append(this.ask).append("\">");
        String[] groupList = this.getGroups();
        int i = 0;
        while (i < groupList.length) {
            String group = groupList[i];
            buf.append("<group>").append(group).append("</group>");
            ++i;
        }
        buf.append("</item>");
        return buf.toString();
    }
}

