/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.drives.impl;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;

public class NewGroupListener
extends GroupEventListener {
    private ManageDriveService driveService_;
    private RepositoryService jcrService_;
    private InitParams initParams_;
    private String groupsPath_;
    private static final String GROUPS_PATH = "groupsPath";

    public NewGroupListener(RepositoryService jcrService, ManageDriveService driveService, NodeHierarchyCreator nodeHierarchyCreatorService, InitParams params) throws Exception {
        this.jcrService_ = jcrService;
        this.driveService_ = driveService;
        this.initParams_ = params;
        this.groupsPath_ = nodeHierarchyCreatorService.getJcrPath(GROUPS_PATH);
    }

    public void preSave(Group group, boolean isNew) throws Exception {
        String groupId = group.getId();
        String name = group.getId().replace("/", ".");
        String repository = this.initParams_.getValueParam("repository").getValue();
        String workspace = this.initParams_.getValueParam("workspace").getValue();
        String permissions = "*:".concat(groupId);
        String extpermissions = this.initParams_.getValueParam("permissions").getValue();
        if (extpermissions != null || extpermissions.length() > 0) {
            permissions.concat(",").concat(extpermissions);
        }
        String homePath = this.groupsPath_ + groupId;
        String views = this.initParams_.getValueParam("views").getValue();
        String icon = this.initParams_.getValueParam("icon").getValue();
        boolean viewPreferences = Boolean.parseBoolean(this.initParams_.getValueParam("viewPreferences").getValue());
        boolean viewNonDocument = Boolean.parseBoolean(this.initParams_.getValueParam("viewNonDocument").getValue());
        boolean viewSideBar = Boolean.parseBoolean(this.initParams_.getValueParam("viewSideBar").getValue());
        boolean showHiddenNode = Boolean.parseBoolean(this.initParams_.getValueParam("showHiddenNode").getValue());
        String allowCreateFolder = this.initParams_.getValueParam("allowCreateFolder").getValue();
        this.driveService_.addDrive(name, workspace, permissions, homePath, views, icon, viewPreferences, viewNonDocument, viewSideBar, showHiddenNode, repository, allowCreateFolder);
    }

    public void preDelete(Group group) throws Exception {
        ManageableRepository repository = this.jcrService_.getCurrentRepository();
        this.driveService_.removeDrive(group.getId().replace("/", "."), repository.getConfiguration().getName());
    }
}

