/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;

public class FileDigestOutputStream
extends DigestOutputStream {
    protected final File file;
    private boolean closed = false;
    private String digestHash = null;

    FileDigestOutputStream(File file, MessageDigest digest) throws IOException {
        super(new FileOutputStream(file), digest);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String getDigestHash() {
        if (this.digestHash == null) {
            StringBuilder hash = new StringBuilder();
            for (byte b : this.digest.digest()) {
                int i = b & 0xFF;
                String hs = Integer.toHexString(i);
                if (hs.length() < 2) {
                    hash.append('0');
                }
                hash.append(hs);
            }
            if (this.closed) {
                this.digestHash = hash.toString();
                return this.digestHash;
            }
            return hash.toString();
        }
        return this.digestHash;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }
}

