/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth {
    public static final String VERSION_1_0 = "1.0";
    public static final String ENCODING = "UTF-8";
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
    public static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    public static final String OAUTH_SIGNATURE = "oauth_signature";
    public static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    public static final String OAUTH_NONCE = "oauth_nonce";
    public static final String OAUTH_VERSION = "oauth_version";
    public static final String HMAC_SHA1 = "HMAC-SHA1";
    public static final String RSA_SHA1 = "RSA-SHA1";

    public static boolean isFormEncoded(String contentType) {
        if (contentType == null) {
            return false;
        }
        int semi = contentType.indexOf(";");
        if (semi >= 0) {
            contentType = contentType.substring(0, semi);
        }
        return FORM_ENCODED.equalsIgnoreCase(contentType.trim());
    }

    public static String formEncode(Iterable<? extends Map.Entry> parameters) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        OAuth.formEncode(parameters, b);
        return new String(b.toByteArray());
    }

    public static void formEncode(Iterable<? extends Map.Entry> parameters, OutputStream into) throws IOException {
        if (parameters != null) {
            boolean first = true;
            for (Map.Entry entry : parameters) {
                if (first) {
                    first = false;
                } else {
                    into.write(38);
                }
                into.write(OAuth.percentEncode(OAuth.toString(entry.getKey())).getBytes());
                into.write(61);
                into.write(OAuth.percentEncode(OAuth.toString(entry.getValue())).getBytes());
            }
        }
    }

    public static List<Parameter> decodeForm(String form) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        if (!OAuth.isEmpty(form)) {
            String[] stringArray = form.split("\\&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                String name;
                String nvp = stringArray[n2];
                int equals = nvp.indexOf(61);
                if (equals < 0) {
                    name = OAuth.decodePercent(nvp);
                    value = null;
                } else {
                    name = OAuth.decodePercent(nvp.substring(0, equals));
                    value = OAuth.decodePercent(nvp.substring(equals + 1));
                }
                list.add(new Parameter(name, value));
                ++n2;
            }
        }
        return list;
    }

    public static String percentEncode(Iterable values) {
        StringBuilder p = new StringBuilder();
        for (Object v : values) {
            if (p.length() > 0) {
                p.append("&");
            }
            p.append(OAuth.percentEncode(OAuth.toString(v)));
        }
        return p.toString();
    }

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    public static String decodePercent(String s) {
        try {
            return URLDecoder.decode(s, ENCODING);
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    public static Map<String, String> newMap(Iterable<? extends Map.Entry> from) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (from != null) {
            for (Map.Entry entry : from) {
                String key = OAuth.toString(entry.getKey());
                if (map.containsKey(key)) continue;
                map.put(key, OAuth.toString(entry.getValue()));
            }
        }
        return map;
    }

    public static List<Parameter> newList(String ... parameters) {
        ArrayList<Parameter> list = new ArrayList<Parameter>(parameters.length / 2);
        int p = 0;
        while (p + 1 < parameters.length) {
            list.add(new Parameter(parameters[p], parameters[p + 1]));
            p += 2;
        }
        return list;
    }

    private static final String toString(Object from) {
        return from == null ? null : from.toString();
    }

    public static String addParameters(String url, String ... parameters) throws IOException {
        return OAuth.addParameters(url, OAuth.newList(parameters));
    }

    public static String addParameters(String url, Iterable<? extends Map.Entry<String, String>> parameters) throws IOException {
        String form = OAuth.formEncode(parameters);
        if (form == null || form.length() <= 0) {
            return url;
        }
        return String.valueOf(url) + (url.indexOf("?") < 0 ? (char)'?' : '&') + form;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameter
    implements Map.Entry<String, String> {
        private final String key;
        private String value;

        public Parameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            try {
                String string = this.value;
                return string;
            }
            finally {
                this.value = value;
            }
        }

        public String toString() {
            return String.valueOf(OAuth.percentEncode(this.getKey())) + '=' + OAuth.percentEncode(this.getValue());
        }
    }

    public static class Problems {
        public static final String TOKEN_NOT_AUTHORIZED = "token_not_authorized";
        public static final String INVALID_USED_NONCE = "invalid_used_nonce";
        public static final String SIGNATURE_INVALID = "signature_invalid";
        public static final String INVALID_EXPIRED_TOKEN = "invalid_expired_token";
        public static final String INVALID_CONSUMER_KEY = "invalid_consumer_key";
        public static final String CONSUMER_KEY_REFUSED = "consumer_key_refused";
        public static final String TIMESTAMP_REFUSED = "timestamp_refused";
        public static final String PARAMETER_REJECTED = "parameter_rejected";
        public static final String PARAMETER_ABSENT = "parameter_absent";
        public static final String VERSION_REJECTED = "version_rejected";
        public static final String SIGNATURE_METHOD_REJECTED = "signature_method_rejected";
        public static final String OAUTH_PARAMETERS_ABSENT = "oauth_parameters_absent";
        public static final String OAUTH_PARAMETERS_REJECTED = "oauth_parameters_rejected";
        public static final String OAUTH_ACCEPTABLE_TIMESTAMPS = "oauth_acceptable_timestamps";
        public static final String OAUTH_ACCEPTABLE_VERSIONS = "oauth_acceptable_versions";
    }
}

