/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.version.Version;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionData;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationHistory;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/publication/lifecycle/stageversion/ui/UIPublicationPanel.gtmpl", events={@EventConfig(listeners={DraftActionListener.class}), @EventConfig(listeners={LiveActionListener.class}), @EventConfig(name="obsolete", listeners={ObsoleteActionListener.class}), @EventConfig(listeners={ChangeVersionActionListener.class}), @EventConfig(listeners={PreviewVersionActionListener.class}), @EventConfig(listeners={RestoreVersionActionListener.class}), @EventConfig(listeners={SeeAllVersionActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIPublicationPanel
extends UIForm {
    private NodeLocation currentNodeLocation;
    private NodeLocation currentRevisionLocation;
    private Map<String, VersionData> revisionsDataMap = new HashMap<String, VersionData>();
    private List<Node> viewedRevisions = new ArrayList<Node>(3);

    public void init(Node node) throws Exception {
        this.currentNodeLocation = NodeLocation.make((Node)node);
        this.currentRevisionLocation = NodeLocation.make((Node)node);
        this.viewedRevisions = this.getLatestRevisions(3, node);
        this.revisionsDataMap = this.getRevisionData(node);
        this.cleanPublicationData(node);
    }

    private void cleanPublicationData(Node node) throws Exception {
        if (this.viewedRevisions.size() == 1 && this.revisionsDataMap.size() > 1) {
            node.setProperty(StageAndVersionPublicationConstant.REVISION_DATA_PROP, new Value[0]);
            node.setProperty(StageAndVersionPublicationConstant.HISTORY, new Value[0]);
            node.setProperty(StageAndVersionPublicationConstant.LIVE_REVISION_PROP, "");
            node.save();
            this.revisionsDataMap = this.getRevisionData(node);
        }
    }

    public List<Node> getAllRevisions(Node node) throws Exception {
        ArrayList<Node> allversions = new ArrayList<Node>();
        VersionIterator iterator = node.getVersionHistory().getAllVersions();
        while (iterator.hasNext()) {
            Version version = iterator.nextVersion();
            if (version.getName().equals("jcr:rootVersion")) continue;
            allversions.add((Node)version);
        }
        allversions.add(node);
        Collections.reverse(allversions);
        return allversions;
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNodeLocation);
    }

    public Node getCurrentRevision() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentRevisionLocation);
    }

    public String getRevisionAuthor(Node revision) throws Exception {
        VersionData revisionData = this.revisionsDataMap.get(revision.getUUID());
        Node currentNode = this.getCurrentNode();
        if (revisionData != null) {
            return revisionData.getAuthor();
        }
        if (revision.getUUID().equalsIgnoreCase(currentNode.getUUID())) {
            return currentNode.getProperty("exo:owner").getString();
        }
        return null;
    }

    public Node getRevisionByUUID(String revisionUUID) throws Exception {
        Session session = this.getCurrentNode().getSession();
        return session.getNodeByUUID(revisionUUID);
    }

    public String getRevisionCreatedDate(Node revision) throws Exception {
        UIPublicationContainer container = (UIPublicationContainer)this.getAncestorOfType(UIPublicationContainer.class);
        DateFormat dateFormater = container.getDateTimeFormater();
        Calendar calendar = null;
        calendar = revision instanceof Version ? ((Version)revision).getCreated() : revision.getProperty("exo:dateCreated").getDate();
        return dateFormater.format(calendar.getTime());
    }

    public List<Node> getRevisions() {
        return this.viewedRevisions;
    }

    public String getRevisionState(Node revision) throws Exception {
        VersionData revisionData = this.revisionsDataMap.get(revision.getUUID());
        Node currentNode = this.getCurrentNode();
        if (revisionData != null) {
            return revisionData.getState();
        }
        if (revision.getUUID().equalsIgnoreCase(currentNode.getUUID())) {
            return currentNode.getProperty(StageAndVersionPublicationConstant.CURRENT_STATE).getString();
        }
        return null;
    }

    public void setCurrentRevision(Node revision) {
        this.currentRevisionLocation = NodeLocation.make((Node)revision);
    }

    public void setRevisions(List<Node> revisions) {
        this.viewedRevisions = revisions;
    }

    public void updatePanel() throws Exception {
        UIPublicationContainer publicationContainer = (UIPublicationContainer)this.getAncestorOfType(UIPublicationContainer.class);
        UIPublicationHistory publicationHistory = (UIPublicationHistory)publicationContainer.getChild(UIPublicationHistory.class);
        publicationHistory.updateGrid();
        Node currentNode = this.getCurrentNode();
        this.revisionsDataMap = this.getRevisionData(currentNode);
        this.viewedRevisions = this.getLatestRevisions(3, currentNode);
    }

    private List<Node> getLatestRevisions(int limit, Node node) throws Exception {
        List<Node> allversions = this.getAllRevisions(node);
        List<Object> latestVersions = new ArrayList();
        latestVersions = allversions.size() > limit ? allversions.subList(0, limit) : allversions;
        return latestVersions;
    }

    private Map<String, VersionData> getRevisionData(Node node) throws Exception {
        HashMap<String, VersionData> map = new HashMap<String, VersionData>();
        try {
            for (Value v : node.getProperty(StageAndVersionPublicationConstant.REVISION_DATA_PROP).getValues()) {
                VersionData versionData = VersionData.toVersionData(v.getString());
                map.put(versionData.getUUID(), versionData);
            }
        }
        catch (Exception e) {
            return map;
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SeeAllVersionActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            publicationPanel.setRevisions(publicationPanel.getAllRevisions(publicationPanel.getCurrentNode()));
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestoreVersionActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node currentNode = publicationPanel.getCurrentNode();
            String versionUUID = event.getRequestContext().getRequestParameter("objectId");
            Version version = (Version)publicationPanel.getRevisionByUUID(versionUUID);
            try {
                currentNode.restore(version, true);
                if (!currentNode.isCheckedOut()) {
                    currentNode.checkout();
                }
                Value[] values = currentNode.getProperty("publication:revisionData").getValues();
                String currentState = "";
                for (Value value : values) {
                    String revisionData = value.getString();
                    if (revisionData.indexOf("published") > 0) {
                        currentState = "published";
                        break;
                    }
                    currentState = "obsolete";
                }
                currentNode.setProperty("publication:currentState", currentState);
                Map revisionsDataMap = publicationPanel.getRevisionData(currentNode);
                ((VersionData)revisionsDataMap.get(currentNode.getUUID())).setState("enrolled");
                ArrayList<Value> valueList = new ArrayList<Value>();
                ValueFactory factory = currentNode.getSession().getValueFactory();
                for (VersionData versionData : revisionsDataMap.values()) {
                    valueList.add(factory.createValue(versionData.toStringValue()));
                }
                currentNode.setProperty(StageAndVersionPublicationConstant.REVISION_DATA_PROP, valueList.toArray(new Value[0]));
                currentNode.getSession().save();
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            }
            UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIPublicationPanel.msg.restore-complete", null));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviewVersionActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObsoleteActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node currentNode = publicationPanel.getCurrentNode();
            PublicationService publicationService = (PublicationService)publicationPanel.getApplicationComponent(PublicationService.class);
            PublicationPlugin publicationPlugin = publicationService.getPublicationPlugins().get(StageAndVersionPublicationConstant.LIFECYCLE_NAME);
            HashMap<String, String> context = new HashMap<String, String>();
            Node currentRevision = publicationPanel.getCurrentRevision();
            if (currentRevision != null) {
                context.put(StageAndVersionPublicationConstant.CURRENT_REVISION_NAME, currentRevision.getName());
            }
            try {
                publicationPlugin.changeState(currentNode, "obsolete", context);
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            }
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LiveActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node currentNode = publicationPanel.getCurrentNode();
            PublicationService publicationService = (PublicationService)publicationPanel.getApplicationComponent(PublicationService.class);
            PublicationPlugin publicationPlugin = publicationService.getPublicationPlugins().get(StageAndVersionPublicationConstant.LIFECYCLE_NAME);
            HashMap<String, String> context = new HashMap<String, String>();
            Node currentRevision = publicationPanel.getCurrentRevision();
            if (currentRevision != null) {
                context.put(StageAndVersionPublicationConstant.CURRENT_REVISION_NAME, currentRevision.getName());
            }
            try {
                publicationPlugin.changeState(currentNode, "published", context);
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            }
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DraftActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            Node currentNode = publicationPanel.getCurrentNode();
            PublicationService publicationService = (PublicationService)publicationPanel.getApplicationComponent(PublicationService.class);
            PublicationPlugin publicationPlugin = publicationService.getPublicationPlugins().get(StageAndVersionPublicationConstant.LIFECYCLE_NAME);
            HashMap<String, String> context = new HashMap<String, String>();
            Node currentRevision = publicationPanel.getCurrentRevision();
            if (currentRevision != null) {
                context.put(StageAndVersionPublicationConstant.CURRENT_REVISION_NAME, currentRevision.getName());
            }
            try {
                publicationPlugin.changeState(currentNode, "draft", context);
                publicationPanel.updatePanel();
            }
            catch (Exception e) {
                UIApplication uiApp = (UIApplication)publicationPanel.getAncestorOfType(UIApplication.class);
            }
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            UIPopupContainer uiPopupContainer = (UIPopupContainer)publicationPanel.getAncestorOfType(UIPopupContainer.class);
            uiPopupContainer.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeVersionActionListener
    extends EventListener<UIPublicationPanel> {
        public void execute(Event<UIPublicationPanel> event) throws Exception {
            UIPublicationPanel publicationPanel = (UIPublicationPanel)((Object)event.getSource());
            String versionUUID = event.getRequestContext().getRequestParameter("objectId");
            Node revision = publicationPanel.getRevisionByUUID(versionUUID);
            publicationPanel.setCurrentRevision(revision);
            UIPublicationContainer publicationContainer = (UIPublicationContainer)publicationPanel.getAncestorOfType(UIPublicationContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPanel, event.getRequestContext());
        }
    }
}

