/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.ArrayList;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ScratchWorkspaceInitializer
implements WorkspaceInitializer {
    protected static final Log log = ExoLogger.getLogger((String)"jcr.WorkspaceInitializer");
    private final String systemWorkspaceName;
    private final String workspaceName;
    private final DataManager dataManager;
    private final String accessControlType;
    private final String rootPermissions;
    private final InternalQName rootNodeType;

    public ScratchWorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, LocationFactory locationFactory) throws RepositoryConfigurationException, PathNotFoundException, RepositoryException {
        this.systemWorkspaceName = repConfig.getSystemWorkspaceName();
        this.accessControlType = repConfig.getAccessControl();
        this.workspaceName = config.getName();
        String rootPermissions = null;
        String rootNodeType = null;
        if (config.getInitializer() != null) {
            rootPermissions = config.getInitializer().getParameterValue("root-permissions", null);
            rootNodeType = config.getInitializer().getParameterValue("root-nodetype", null);
        }
        if (config.getAutoInitializedRootNt() != null) {
            if (rootNodeType == null) {
                rootNodeType = config.getAutoInitializedRootNt();
                log.warn((Object)("[" + this.workspaceName + "] auto-init-root-nodetype (" + rootNodeType + ") parameter is DEPRECATED ! Use <initializer .../> instead."));
            } else {
                log.warn((Object)("[" + this.workspaceName + "] auto-init-root-nodetype parameter is DEPRECATED ! Skipped."));
            }
        }
        if (config.getAutoInitPermissions() != null) {
            if (rootPermissions == null) {
                rootPermissions = config.getAutoInitPermissions();
                log.warn((Object)("[" + this.workspaceName + "] auto-init-permissions (" + rootPermissions + ") parameter is DEPRECATED ! Use <initializer .../> instead."));
            } else {
                log.warn((Object)("[" + this.workspaceName + "] auto-init-permissions parameter is DEPRECATED ! Skipped."));
            }
        }
        this.rootPermissions = rootPermissions;
        this.rootNodeType = rootNodeType != null ? locationFactory.parseJCRName(rootNodeType).getInternalName() : Constants.NT_UNSTRUCTURED;
        this.dataManager = dataManager;
    }

    public NodeData initWorkspace() throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000");
        }
        NodeData root = this.initRootNode(this.rootNodeType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Root node for " + this.workspaceName + " initialized. NodeType: " + (Object)((Object)this.rootNodeType) + " system workspace: " + this.systemWorkspaceName));
        }
        if (this.workspaceName.equals(this.systemWorkspaceName)) {
            NodeData nodeData = this.initJcrSystemNode(root);
        }
        return root;
    }

    public void start() {
    }

    public boolean isWorkspaceInitialized() {
        try {
            return this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000") != null;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private NodeData initRootNode(InternalQName rootNodeType) throws RepositoryException {
        TransientNodeData rootNode;
        boolean addACL = !this.accessControlType.equals("disable");
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            if (this.rootPermissions != null) {
                acl.removePermissions(SystemIdentity.ANY);
                acl.addPermissions(this.rootPermissions);
            }
            InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
            rootNode = new TransientNodeData(Constants.ROOT_PATH, "00exo0jcr0root0uuid0000000000000", -1, rootNodeType, mixins, 0, null, acl);
            changesLog.add(new ItemState(rootNode, 1, false, null));
            TransientPropertyData primaryType = new TransientPropertyData(QPath.makeChildPath(rootNode.getQPath(), Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, rootNode.getIdentifier(), false, new TransientValueData(rootNodeType));
            changesLog.add(new ItemState(primaryType, 1, false, null));
            ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
            for (InternalQName mixin : mixins) {
                mixValues.add(new TransientValueData(mixin));
            }
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)rootNode, Constants.JCR_MIXINTYPES, 7, true, mixValues);
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)rootNode, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = acl.getPermissionEntries().get(i);
                permsValues.add(new TransientValueData(entry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)rootNode, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
            changesLog.add(new ItemState(rootNode, 16, false, null));
        } else {
            rootNode = new TransientNodeData(Constants.ROOT_PATH, "00exo0jcr0root0uuid0000000000000", -1, rootNodeType, new InternalQName[0], 0, null, new AccessControlList());
            changesLog.add(new ItemState(rootNode, 1, false, null));
            TransientPropertyData primaryType = new TransientPropertyData(QPath.makeChildPath(rootNode.getQPath(), Constants.JCR_PRIMARYTYPE), IdGenerator.generate(), -1, 7, rootNode.getIdentifier(), false, new TransientValueData(rootNodeType));
            changesLog.add(new ItemState(primaryType, 1, false, null));
        }
        this.dataManager.save(new TransactionChangesLog(changesLog));
        return rootNode;
    }

    private NodeData initJcrSystemNode(NodeData root) throws RepositoryException {
        TransientNodeData jcrSystem;
        boolean addACL = !this.accessControlType.equals("disable");
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
            jcrSystem = TransientNodeData.createNodeData(root, Constants.JCR_SYSTEM, Constants.NT_UNSTRUCTURED, mixins, "00exo0jcr0system0uuid00000000000");
            TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)jcrSystem, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(jcrSystem.getPrimaryTypeName()));
            changesLog.add(ItemState.createAddedState(jcrSystem)).add(ItemState.createAddedState(primaryType));
            ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
            for (InternalQName mixin : mixins) {
                mixValues.add(new TransientValueData(mixin));
            }
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)jcrSystem, Constants.JCR_MIXINTYPES, 7, true, mixValues);
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)jcrSystem, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = acl.getPermissionEntries().get(i);
                permsValues.add(new TransientValueData(entry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)jcrSystem, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
            changesLog.add(new ItemState(jcrSystem, 16, false, null));
        } else {
            jcrSystem = TransientNodeData.createNodeData(root, Constants.JCR_SYSTEM, Constants.NT_UNSTRUCTURED, "00exo0jcr0system0uuid00000000000");
            TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)jcrSystem, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(jcrSystem.getPrimaryTypeName()));
            changesLog.add(ItemState.createAddedState(jcrSystem)).add(ItemState.createAddedState(primaryType));
        }
        TransientNodeData versionStorageNodeData = TransientNodeData.createNodeData((NodeData)jcrSystem, Constants.JCR_VERSIONSTORAGE, Constants.EXO_VERSIONSTORAGE, "00exo0jcr0version0storage0uuid00");
        TransientPropertyData vsPrimaryType = TransientPropertyData.createPropertyData((NodeData)versionStorageNodeData, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(versionStorageNodeData.getPrimaryTypeName()));
        changesLog.add(ItemState.createAddedState(versionStorageNodeData)).add(ItemState.createAddedState(vsPrimaryType));
        this.dataManager.save(new TransactionChangesLog(changesLog));
        return jcrSystem;
    }

    public void stop() {
    }
}

