/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionPlugin;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.DMSEvent;
import org.exoplatform.services.cms.actions.impl.ActionConfig;
import org.exoplatform.services.cms.actions.impl.ECMEventListener;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.JobSchedulerService;
import org.exoplatform.services.scheduler.PeriodInfo;
import org.quartz.JobDataMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseActionPlugin
implements ActionPlugin {
    static final String JOB_NAME_PREFIX = "activate_".intern();
    static final String PERIOD_JOB = "period".intern();
    static final String CRON_JOB = "cron".intern();
    static final String SCHEDULABLE_INFO_MIXIN = "exo:schedulableInfo".intern();
    static final String SCHEDULED_INITIATOR = "exo:scheduledInitiator".intern();
    static final String JOB_NAME_PROP = "exo:jobName".intern();
    static final String JOB_GROUP_PROP = "exo:jobGroup".intern();
    static final String JOB_DESCRIPTION_PROP = "exo:jobDescription".intern();
    static final String JOB_CLASS_PROP = "exo:jobClass".intern();
    static final String SCHEDULE_TYPE_PROP = "exo:scheduleType".intern();
    static final String START_TIME_PROP = "exo:startTime".intern();
    static final String END_TIME_PROP = "exo:endTime".intern();
    static final String REPEAT_COUNT_PROP = "exo:repeatCount".intern();
    static final String TIME_INTERVAL_PROP = "exo:timeInterval".intern();
    static final String CRON_EXPRESSION_PROP = "exo:cronExpression".intern();
    static final String LIFECYCLE_PHASE_PROP = "exo:lifecyclePhase".intern();
    static final String NODE_NAME_PROP = "exo:name".intern();
    static final String COUNTER_PROP = "exo:counter".intern();
    static final String EXO_ACTIONS = "exo:actions".intern();
    static final String ACTION_STORAGE = "exo:actionStorage".intern();
    static final long BUFFER_TIME = 500000L;
    static final String actionNameVar = "actionName".intern();
    static final String srcRepository = "repository".intern();
    static final String srcWorkspaceVar = "srcWorkspace".intern();
    static final String initiatorVar = "initiator".intern();
    static final String srcPathVar = "srcPath".intern();
    static final String executableVar = "executable".intern();
    static final String MIX_AFFECTED_NODETYPE = "mix:affectedNodeTypes".intern();
    static final String AFFECTED_NODETYPE = "exo:affectedNodeTypeNames".intern();
    static final String ALL_DOCUMENT_TYPES = "ALL_DOCUMENT_TYPES".intern();
    protected Map<String, ECMEventListener> listeners_ = new HashMap<String, ECMEventListener>();
    private static final Log LOG = ExoLogger.getLogger(BaseActionPlugin.class);

    protected abstract String getRepositoryName();

    protected abstract List<RepositoryEntry> getRepositories();

    protected abstract String getWorkspaceName();

    protected abstract ManageableRepository getRepository(String var1) throws Exception;

    protected abstract String getActionType();

    protected abstract List getActions();

    protected abstract ECMEventListener createEventListener(String var1, String var2, String var3, String var4, String var5, Map var6, String var7) throws Exception;

    protected abstract Class createActivationJob() throws Exception;

    @Override
    public void addAction(String actionType, String repository, String srcWorkspace, String srcPath, Map mappings) throws Exception {
        this.addAction(actionType, repository, srcWorkspace, srcPath, true, null, null, mappings);
    }

    @Override
    public void addAction(String actionType, String repository, String srcWorkspace, String srcPath, boolean isDeep, String[] uuid, String[] nodeTypeNames, Map mappings) throws Exception {
        String actionName = (String)((JcrInputProperty)mappings.get("/node/exo:name")).getValue();
        mappings.remove("/node/exo:name");
        String[] type = (String[])((JcrInputProperty)mappings.get("/node/exo:lifecyclePhase")).getValue();
        String actionExecutable = this.getActionExecutable(actionType);
        if (DMSEvent.getEventTypes(type) == 2048) {
            return;
        }
        if ((DMSEvent.getEventTypes(type) & 0x1000) > 0) {
            this.scheduleActionActivationJob(repository, srcWorkspace, srcPath, actionName, actionType, actionExecutable, mappings);
        }
        if (DMSEvent.getEventTypes(type) == 4096) {
            return;
        }
        Map<String, Object> variables = this.getExecutionVariables(mappings);
        ECMEventListener listener = this.createEventListener(actionName, actionExecutable, repository, srcWorkspace, srcPath, variables, actionType);
        Session session = this.getSystemSession(repository, srcWorkspace);
        ObservationManager obsManager = session.getWorkspace().getObservationManager();
        String listenerKey = repository + ":" + srcPath + "/exo:actions/" + actionName;
        if (this.listeners_.containsKey(listenerKey)) {
            obsManager.removeEventListener((EventListener)this.listeners_.get(listenerKey));
            this.listeners_.remove(listenerKey);
        }
        obsManager.addEventListener((EventListener)listener, DMSEvent.getEventTypes(type), srcPath, isDeep, uuid, nodeTypeNames, false);
        session.logout();
        this.listeners_.put(listenerKey, listener);
    }

    @Override
    public void initiateActionObservation(Node storedActionNode, String repository) throws Exception {
        PropertyDefinition[] defs;
        String[] lifecyclePhase;
        String actionName = storedActionNode.getProperty("exo:name").getString();
        String[] stringArray = lifecyclePhase = storedActionNode.hasProperty("exo:lifecyclePhase") ? this.parseValuesToArray(storedActionNode.getProperty("exo:lifecyclePhase").getValues()) : null;
        if (DMSEvent.getEventTypes(lifecyclePhase) == 2048) {
            return;
        }
        String[] uuid = storedActionNode.hasProperty("exo:uuid") ? this.parseValuesToArray(storedActionNode.getProperty("exo:uuid").getValues()) : null;
        boolean isDeep = storedActionNode.hasProperty("exo:isDeep") ? storedActionNode.getProperty("exo:isDeep").getBoolean() : true;
        String[] nodeTypeNames = storedActionNode.hasProperty("exo:nodeTypeName") ? this.parseValuesToArray(storedActionNode.getProperty("exo:nodeTypeName").getValues()) : null;
        String actionType = storedActionNode.getPrimaryNodeType().getName();
        String srcWorkspace = storedActionNode.getSession().getWorkspace().getName();
        String srcPath = storedActionNode.getParent().getParent().getPath();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        NodeType nodeType = storedActionNode.getPrimaryNodeType();
        for (PropertyDefinition propDef : defs = nodeType.getPropertyDefinitions()) {
            if (propDef.isMultiple()) continue;
            String key = propDef.getName();
            try {
                Object value = this.getPropertyValue(storedActionNode.getProperty(key));
                variables.put(key, value);
            }
            catch (Exception e) {
                variables.put(key, null);
            }
        }
        String actionExecutable = this.getActionExecutable(actionType);
        ECMEventListener listener = this.createEventListener(actionName, actionExecutable, repository, srcWorkspace, srcPath, variables, actionType);
        Session session = this.getSystemSession(repository, srcWorkspace);
        String listenerKey = repository + ":" + srcPath + "/exo:actions/" + actionName;
        ObservationManager obsManager = session.getWorkspace().getObservationManager();
        if (this.listeners_.containsKey(listenerKey)) {
            obsManager.removeEventListener((EventListener)this.listeners_.get(listenerKey));
            this.listeners_.remove(listenerKey);
        }
        obsManager.addEventListener((EventListener)listener, DMSEvent.getEventTypes(lifecyclePhase), srcPath, isDeep, uuid, nodeTypeNames, false);
        session.logout();
        this.listeners_.put(listenerKey, listener);
    }

    @Override
    public void reScheduleActivations(Node storedActionNode, String repository) throws Exception {
        PropertyDefinition[] defs;
        String jobClassName = storedActionNode.getProperty(JOB_CLASS_PROP).getString();
        Class<?> activationJobClass = null;
        try {
            activationJobClass = Class.forName(jobClassName);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return;
        }
        String actionName = storedActionNode.getProperty(NODE_NAME_PROP).getString();
        String actionType = storedActionNode.getPrimaryNodeType().getName();
        String srcWorkspace = storedActionNode.getSession().getWorkspace().getName();
        String scheduleType = storedActionNode.getProperty(SCHEDULE_TYPE_PROP).getString();
        String initiator = storedActionNode.getProperty(SCHEDULED_INITIATOR).getString();
        String srcPath = storedActionNode.getParent().getParent().getPath();
        String jobName = storedActionNode.getProperty(JOB_NAME_PROP).getString();
        String jobGroup = storedActionNode.getProperty(JOB_GROUP_PROP).getString();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        NodeType nodeType = storedActionNode.getPrimaryNodeType();
        for (PropertyDefinition propDef : defs = nodeType.getPropertyDefinitions()) {
            if (propDef.isMultiple()) continue;
            String key = propDef.getName();
            try {
                Object value = this.getPropertyValue(storedActionNode.getProperty(key));
                variables.put(key, value);
            }
            catch (Exception e) {
                variables.put(key, null);
            }
        }
        String actionExecutable = this.getActionExecutable(actionType);
        variables.put(initiatorVar, initiator);
        variables.put(actionNameVar, actionName);
        variables.put(srcRepository, repository);
        variables.put(executableVar, actionExecutable);
        variables.put(srcWorkspaceVar, srcWorkspace);
        variables.put(srcPathVar, srcPath);
        JobDataMap jdatamap = new JobDataMap();
        JobInfo jinfo = new JobInfo(jobName, jobGroup, activationJobClass);
        jdatamap.putAll(variables);
        if (CRON_JOB.equals(scheduleType)) {
            String cronExpression = storedActionNode.getProperty(CRON_EXPRESSION_PROP).getString();
            schedulerService.addCronJob(jinfo, cronExpression, jdatamap);
        } else {
            Calendar endTime = null;
            Date endDate = null;
            if (storedActionNode.hasProperty(END_TIME_PROP)) {
                endTime = storedActionNode.getProperty(END_TIME_PROP).getDate();
            }
            if (endTime != null) {
                endDate = endTime.getTime();
            }
            long timeInterval = storedActionNode.getProperty(TIME_INTERVAL_PROP).getLong();
            Date startDate = new Date(System.currentTimeMillis() + 500000L);
            int repeatCount = (int)storedActionNode.getProperty(REPEAT_COUNT_PROP).getLong();
            int counter = (int)storedActionNode.getProperty(COUNTER_PROP).getLong();
            PeriodInfo pinfo = new PeriodInfo(startDate, endDate, repeatCount - counter, timeInterval);
            schedulerService.addPeriodJob(jinfo, pinfo, jdatamap);
        }
    }

    protected Session getSystemSession(String repository, String workspace) throws Exception {
        ManageableRepository jcrRepository = this.getRepository(repository);
        return jcrRepository.getSystemSession(workspace);
    }

    @Override
    public String getActionExecutable(String actionTypeName) throws Exception {
        ExtendedNodeTypeManager ntManager = this.getRepository(this.getRepositoryName()).getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(actionTypeName);
        PropertyDefinition[] propDefs = nt.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            PropertyDefinition definition = propDefs[i];
            if (!definition.getName().equals(this.getExecutableDefinitionName()) || definition.getDefaultValues() == null) continue;
            return definition.getDefaultValues()[0].getString();
        }
        return null;
    }

    @Override
    public boolean isActionTypeSupported(String actionType) {
        try {
            ExtendedNodeTypeManager ntmanager = this.getRepository(this.getRepositoryName()).getNodeTypeManager();
            for (NodeType type : ntmanager.getNodeType(actionType).getSupertypes()) {
                if (!this.getActionType().equals(type.getName())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void removeObservation(String repository, String actionPath) throws Exception {
        ECMEventListener eventListener = this.listeners_.get(repository + ":" + actionPath);
        if (eventListener != null) {
            String srcWorkspace = eventListener.getSrcWorkspace();
            Session session = this.getSystemSession(repository, srcWorkspace);
            ObservationManager obsManager = session.getWorkspace().getObservationManager();
            obsManager.removeEventListener((EventListener)eventListener);
            session.logout();
        }
        this.listeners_.remove(repository + ":" + actionPath);
    }

    @Override
    public void removeActivationJob(String jobName, String jobGroup, String jobClass) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        Class<?> activationJob = null;
        try {
            activationJob = Class.forName(jobClass);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        if (activationJob == null) {
            return;
        }
        JobInfo jinfo = new JobInfo(jobName, jobGroup, activationJob);
        schedulerService.removeJob(jinfo);
    }

    @Override
    public boolean isVariable(String variable) throws Exception {
        ExtendedNodeTypeManager ntManager = this.getRepository(this.getRepositoryName()).getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(this.getActionType());
        PropertyDefinition[] propDefs = nt.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            PropertyDefinition definition = propDefs[i];
            if (!definition.getName().equals(variable)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<String> getVariableNames(String actionTypeName) throws Exception {
        ArrayList<String> variableNames = new ArrayList<String>();
        ExtendedNodeTypeManager ntManager = this.getRepository(this.getRepositoryName()).getNodeTypeManager();
        NodeType nt = ntManager.getNodeType(actionTypeName);
        PropertyDefinition[] propDefs = nt.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propDefs.length; ++i) {
            PropertyDefinition definition = propDefs[i];
            if (!this.isVariable(definition.getName())) continue;
            variableNames.add(definition.getName());
        }
        return variableNames;
    }

    protected void importPredefinedActionsInJcr() throws Exception {
        List actions = this.getActions();
        if (actions.isEmpty()) {
            return;
        }
        Session session = null;
        for (ActionConfig.Action action : actions) {
            try {
                session = this.getSystemSession(this.getRepositoryName(), action.getSrcWorkspace());
                this.importAction(action, session);
                session.logout();
            }
            catch (Exception e) {
                if (session != null) {
                    session.logout();
                }
                System.out.println("[WARNING] ==> Can not init action '" + action.getName() + "' in repository '" + this.getRepositoryName() + "' and workspace '" + action.getSrcWorkspace() + "'");
            }
        }
    }

    protected void reImportPredefinedActionsInJcr(String repository) throws Exception {
        List actions = this.getActions();
        if (actions.isEmpty()) {
            return;
        }
        Session session = null;
        for (ActionConfig.Action action : actions) {
            if (!repository.equals(this.getRepositoryName())) continue;
            try {
                session = this.getSystemSession(repository, action.getSrcWorkspace());
                this.importAction(action, session);
            }
            catch (Exception e) {
                if (session != null) {
                    session.logout();
                }
                System.out.println("[WARNING] ==> Can not init action '" + action.getName() + "' in repository '" + repository + "' and workspace '" + action.getSrcWorkspace() + "'");
            }
        }
    }

    private void importAction(ActionConfig.Action action, Session session) throws Exception {
        Node srcNode = (Node)session.getItem(action.getSrcPath());
        Node actionNode = null;
        boolean firstImport = false;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        ActionServiceContainer actionContainer = (ActionServiceContainer)container.getComponentInstanceOfType(ActionServiceContainer.class);
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        TemplateService templateService = (TemplateService)container.getComponentInstanceOfType(TemplateService.class);
        ManageableRepository manageRepo = repositoryService.getRepository(this.getRepositoryName());
        Node actionNodeName = null;
        try {
            actionNodeName = actionContainer.getAction(srcNode, action.getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        Node actionsNode = null;
        if (actionNodeName == null) {
            firstImport = true;
            if (!srcNode.isNodeType("exo:actionable")) {
                srcNode.addMixin("exo:actionable");
            }
            try {
                actionsNode = srcNode.getNodes(EXO_ACTIONS).nextNode();
            }
            catch (Exception e) {
                actionsNode = srcNode.addNode(EXO_ACTIONS, ACTION_STORAGE);
                srcNode.save();
            }
            actionNode = actionsNode.addNode(action.getName(), action.getType());
            actionNode.setProperty("exo:name", action.getName());
            actionNode.setProperty("exo:description", action.getDescription());
            actionNode.setProperty("exo:isDeep", action.isDeep());
            if (action.getUuid() != null) {
                actionNode.setProperty("exo:uuid", action.getUuid().toArray(new String[0]));
            }
            if (action.getNodeTypeName() != null) {
                actionNode.setProperty("exo:nodeTypeName", action.getNodeTypeName().toArray(new String[0]));
            }
            if (action.getLifecyclePhase() != null) {
                actionNode.setProperty("exo:lifecyclePhase", action.getLifecyclePhase().toArray(new String[0]));
            }
            if (action.getRoles() != null) {
                String[] roles = StringUtils.split((String)action.getRoles(), (String)";");
                actionNode.setProperty("exo:roles", roles);
            }
            for (ActionConfig.Mixin mixin : action.getMixins()) {
                actionNode.addMixin(mixin.getName());
                Map<String, String> props = mixin.getParsedProperties();
                Set<String> keys = props.keySet();
                NodeType nodeType = manageRepo.getNodeTypeManager().getNodeType(mixin.getName());
                block5: for (String key : keys) {
                    for (PropertyDefinition pro : nodeType.getPropertyDefinitions()) {
                        if (!pro.getName().equals(key)) continue;
                        if (pro.isMultiple()) {
                            String value = props.get(key);
                            if (value == null) continue block5;
                            actionNode.setProperty(key, value.split(";"));
                            continue block5;
                        }
                        actionNode.setProperty(key, props.get(key));
                        continue block5;
                    }
                }
            }
        } else {
            actionNodeName = actionContainer.getAction(srcNode, action.getName());
        }
        String unparsedVariables = action.getVariables();
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        if (unparsedVariables != null && !"".equals(unparsedVariables)) {
            String[] variables = StringUtils.split((String)unparsedVariables, (String)";");
            for (int i = 0; i < variables.length; ++i) {
                String variable = variables[i];
                String[] keyValue = StringUtils.split((String)variable, (String)"=");
                String variableKey = keyValue[0];
                String variableValue = keyValue[1];
                variablesMap.put(variableKey, variableValue);
                if (!firstImport) continue;
                actionNode.setProperty(variableKey, variableValue);
            }
        }
        if (firstImport) {
            srcNode.save();
        }
    }

    private void scheduleActionActivationJob(String repository, String srcWorkspace, String srcPath, String actionName, String actionType, String actionExecutable, Map mappings) throws Exception {
        Session session;
        Node srcNode;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        JobSchedulerService schedulerService = (JobSchedulerService)container.getComponentInstanceOfType(JobSchedulerService.class);
        ActionServiceContainer actionContainer = (ActionServiceContainer)container.getComponentInstanceOfType(ActionServiceContainer.class);
        Node actionNode = actionContainer.getAction(srcNode = (Node)(session = this.getSystemSession(repository, srcWorkspace)).getItem(srcPath), actionName);
        if (!actionNode.isNodeType(SCHEDULABLE_INFO_MIXIN)) {
            actionNode.addMixin(SCHEDULABLE_INFO_MIXIN);
            actionNode.save();
        }
        Class activationJob = this.createActivationJob();
        String jobName = JOB_NAME_PREFIX.concat(actionName);
        String jobGroup = actionType;
        String userId = session.getUserID();
        String scheduleType = null;
        String repeatCount = null;
        String timeInterval = null;
        String cronExpress = null;
        GregorianCalendar startTime = new GregorianCalendar();
        GregorianCalendar endTime = null;
        if (mappings.containsKey("/node/exo:scheduleType")) {
            scheduleType = (String)((JcrInputProperty)mappings.get("/node/exo:scheduleType")).getValue();
            mappings.remove("/node/exo:scheduleType");
        }
        if (mappings.containsKey("/node/exo:startTime")) {
            startTime = (GregorianCalendar)((JcrInputProperty)mappings.get("/node/exo:startTime")).getValue();
            mappings.remove("/node/exo:startTime");
        }
        if (mappings.containsKey("/node/exo:endTime")) {
            endTime = (GregorianCalendar)((JcrInputProperty)mappings.get("/node/exo:endTime")).getValue();
            mappings.remove("/node/exo:endTime");
        }
        if (mappings.containsKey("/node/exo:repeatCount")) {
            repeatCount = (String)((JcrInputProperty)mappings.get("/node/exo:repeatCount")).getValue();
            mappings.remove("/node/exo:repeatCount");
        }
        if (mappings.containsKey("/node/exo:timeInterval")) {
            timeInterval = (String)((JcrInputProperty)mappings.get("/node/exo:timeInterval")).getValue();
            mappings.remove("/node/exo:timeInterval");
        }
        if (mappings.containsKey("/node/exo:cronExpression")) {
            cronExpress = (String)((JcrInputProperty)mappings.get("/node/exo:cronExpression")).getValue();
            mappings.remove("/node/exo:cronExpression");
        }
        actionNode.setProperty(JOB_NAME_PROP, jobName);
        actionNode.setProperty(JOB_GROUP_PROP, jobGroup);
        actionNode.setProperty(JOB_CLASS_PROP, activationJob.getName());
        actionNode.setProperty(SCHEDULED_INITIATOR, userId);
        actionNode.setProperty(SCHEDULE_TYPE_PROP, scheduleType);
        actionNode.save();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(initiatorVar, userId);
        variables.put(actionNameVar, actionName);
        variables.put(executableVar, actionExecutable);
        variables.put(srcWorkspaceVar, srcWorkspace);
        variables.put(srcRepository, repository);
        variables.put(srcPathVar, srcPath);
        Map<String, Object> executionVariables = this.getExecutionVariables(mappings);
        JobDataMap jdatamap = new JobDataMap();
        jdatamap.putAll(variables);
        jdatamap.putAll(executionVariables);
        JobInfo jinfo = new JobInfo(jobName, jobGroup, activationJob);
        if (scheduleType.equals(CRON_JOB)) {
            actionNode.setProperty(CRON_EXPRESSION_PROP, cronExpress);
            actionNode.save();
            schedulerService.addCronJob(jinfo, cronExpress, jdatamap);
        } else {
            int repeatNum = Integer.parseInt(repeatCount);
            long period = Long.parseLong(timeInterval);
            actionNode.setProperty(START_TIME_PROP, (Calendar)startTime);
            if (endTime != null) {
                actionNode.setProperty(END_TIME_PROP, (Calendar)endTime);
            }
            actionNode.setProperty(TIME_INTERVAL_PROP, period);
            actionNode.setProperty(REPEAT_COUNT_PROP, (long)repeatNum);
            actionNode.save();
            PeriodInfo pinfo = endTime != null ? new PeriodInfo(startTime.getTime(), endTime.getTime(), repeatNum, period) : new PeriodInfo(repeatNum, period);
            schedulerService.addPeriodJob(jinfo, pinfo, jdatamap);
        }
        session.save();
        session.logout();
    }

    private Map<String, Object> getExecutionVariables(Map mappings) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Set keys = mappings.keySet();
        for (String key : keys) {
            Object value = ((JcrInputProperty)mappings.get(key)).getValue();
            key = key.substring(key.lastIndexOf("/") + 1);
            variables.put(key, value);
        }
        return variables;
    }

    private Object getPropertyValue(Property property) throws Exception {
        int propertyType = property.getType();
        switch (propertyType) {
            case 1: {
                return property.getValue().getString();
            }
            case 6: {
                return property.getValue().getBoolean();
            }
            case 5: {
                return property.getValue().getDate();
            }
            case 4: {
                return property.getValue().getDouble();
            }
            case 3: {
                return property.getValue().getLong();
            }
            case 7: {
                return property.getValue().getString();
            }
            case 0: {
                return property.getValue();
            }
        }
        return null;
    }

    private String[] parseValuesToArray(Value[] values) throws Exception {
        String[] valueToString = new String[values.length];
        int i = 0;
        for (Value value : values) {
            valueToString[i++] = value.getString();
        }
        return valueToString;
    }
}

