/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.images.RESTImagesRendererService;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, events={@EventConfig(listeners={RefreshActionListener.class}), @EventConfig(listeners={EditContentActionListener.class})}), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UICLVPresentation
extends UIContainer {
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private String contentColumn;
    private boolean showLink;
    private boolean showHeader;
    private boolean showReadmore;
    private String header;
    private DateFormat dateFormatter = null;

    public void init(String templatePath, ResourceResolver resourceResolver, PageList dataPageList) throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String paginatorTemplatePath = portletPreferences.getValue("paginatorTemplatePath", null);
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
        this.uiPaginator.setPageList(dataPageList);
        Locale locale = Util.getPortalRequestContext().getLocale();
        this.dateFormatter = SimpleDateFormat.getDateTimeInstance(2, 2, locale);
    }

    private PortletPreferences getPortletPreferences() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = context.getRequest().getPreferences();
        return portletPreferences;
    }

    public boolean showRefreshButton() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String isShow = portletPreferences.getValue("showRefreshButton", null);
        return isShow != null ? Boolean.parseBoolean(isShow) : false;
    }

    public boolean isShowField(String field) {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue(field, null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    public boolean showPaginator() throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public DateFormat getDatetimeFommatter() {
        return this.dateFormatter;
    }

    public void setDateTimeFormat(String format) {
        ((SimpleDateFormat)this.dateFormatter).applyPattern(format);
    }

    public String getContentColumn() {
        return this.contentColumn;
    }

    public void setContentColumn(String column) {
        this.contentColumn = column;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPaginator;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public List getCurrentPageData() throws Exception {
        return this.uiPaginator.getCurrentPageData();
    }

    public String getTitle(Node node) throws Exception {
        String title = null;
        if (node.hasNode("jcr:content")) {
            Node content = node.getNode("jcr:content");
            if (content.hasProperty("dc:title")) {
                try {
                    title = content.getProperty("dc:title").getValues()[0].getString();
                }
                catch (Exception ex) {}
            }
        } else if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (title == null) {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                title = originalNode.getName();
            } else {
                title = node.getName();
            }
        }
        return title;
    }

    public String getSummary(Node node) throws Exception {
        Node content;
        String desc = null;
        if (node.hasProperty("exo:summary")) {
            desc = node.getProperty("exo:summary").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:description")) {
            try {
                desc = content.getProperty("dc:description").getValues()[0].getString();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return desc;
    }

    public String getURL(Node node) throws Exception {
        String link = null;
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        String portalURI = portalRequestContext.getPortalURI();
        PortletPreferences portletPreferences = this.getPortletPreferences();
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        String basePath = portletPreferences.getValue("basePath", null);
        link = baseURI + portalURI + basePath + "?path=/" + nodeLocation.getRepository() + "/" + nodeLocation.getWorkspace() + node.getPath();
        return link;
    }

    public String getWebdavURL(Node node) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest portletRequest = portletRequestContext.getRequest();
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)node);
        String repository = nodeLocation.getRepository();
        String workspace = nodeLocation.getWorkspace();
        String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort());
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getCurrentRestContextName();
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            Node originalNode = node.getSession().getNodeByUUID(uuid);
            return baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + originalNode.getPath() + "?version=" + node.getParent().getName();
        }
        return baseURI + "/" + portalName + "/" + restContextName + "/jcr/" + repository + "/" + workspace + node.getPath();
    }

    public String getAuthor(Node node) throws Exception {
        if (node.hasProperty("exo:owner")) {
            String ownerId = node.getProperty("exo:owner").getValue().getString();
            OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
            UserHandler handler = organizationService.getUserHandler();
            User user = handler.findUserByName(ownerId);
            if (user != null) {
                return user.getFullName();
            }
            return ownerId;
        }
        return null;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getModifiedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateModified")) {
            Calendar calendar = node.getProperty("exo:dateModified").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getContentType(Node node) {
        return null;
    }

    public String getContentIcon(Node node) {
        try {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                Node originalNode = node.getSession().getNodeByUUID(uuid);
                return "Icon16x16 default16x16Icon " + org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)originalNode, (String)"16x16Icon");
            }
            return "Icon16x16 default16x16Icon " + org.exoplatform.ecm.webui.utils.Utils.getNodeTypeIcon((Node)node, (String)"16x16Icon");
        }
        catch (RepositoryException e) {
            Utils.createPopupMessage((org.exoplatform.webui.core.UIContainer)this, (String)"UIMessageBoard.msg.get-content-icon", null, (int)0);
            return null;
        }
    }

    public String getContentSize(Node node) {
        return null;
    }

    public String getIllustrativeImage(Node node) {
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        RESTImagesRendererService imagesRendererService = (RESTImagesRendererService)this.getApplicationComponent(RESTImagesRendererService.class);
        Node illustrativeImage = null;
        String uri = null;
        try {
            illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
            uri = imagesRendererService.generateImageURI(illustrativeImage, null);
        }
        catch (PathNotFoundException ex) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uri;
    }

    public List<String> getCategories(Node node) {
        return null;
    }

    public List<String> getTags(Node node) {
        return null;
    }

    public float getVotingRate(Node node) {
        return 0.0f;
    }

    public int getNumberOfComments(Node node) {
        return 0;
    }

    public List<Node> getRelatedContents(Node node) {
        return null;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public boolean isShowReadmore() {
        return this.showReadmore;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public void setShowReadmore(boolean showReadmore) {
        this.showReadmore = showReadmore;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }
}

