/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.UIBaseNodePresentation;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;

@ComponentConfig(lifecycle=Lifecycle.class)
public class UIPCVPresentation
extends UIBaseNodePresentation {
    private NodeLocation contentNodeLocation;
    private NodeLocation originalNodeLocation;
    private JCRResourceResolver resourceResolver;
    private String repository;
    private String workspace;
    public static final String CONTENT_NOT_FOUND_EXC = "UIMessageBoard.msg.content-not-found";
    public static final String ACCESS_CONTROL_EXC = "UIMessageBoard.msg.access-control-exc";
    public static final String CONTENT_UNSUPPORT_EXC = "UIMessageBoard.msg.content-unsupport-exc";
    public static final String CONTENT_NOT_PRINTED = "UIMessageBoard.msg.content-invisible";
    public static final String OBSOLETE_CONTENT = "UIMessageBoard.msg.content-obsolete";
    public static final String PARAMETER_REGX = "(.*)/(.*)";

    public Node getNode() throws Exception {
        return Utils.getViewableNodeByComposer((String)this.contentNodeLocation.getRepository(), (String)this.contentNodeLocation.getWorkspace(), (String)this.contentNodeLocation.getPath());
    }

    public Node getOriginalNode() throws Exception {
        return Utils.getViewableNodeByComposer((String)this.originalNodeLocation.getRepository(), (String)this.originalNodeLocation.getWorkspace(), (String)this.originalNodeLocation.getPath(), (String)"base");
    }

    public void setOriginalNode(Node originalNode) {
        this.originalNodeLocation = NodeLocation.make((Node)originalNode);
    }

    public String getRepositoryName() throws Exception {
        return this.repository;
    }

    public String getWorkspaceName() throws Exception {
        return this.workspace;
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        String mimeType = jcrContentNode.getProperty("jcr:mimeType").getString();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, mimeType);
        DMSMimeTypeResolver mimeTypeSolver = DMSMimeTypeResolver.getInstance();
        String ext = mimeTypeSolver.getExtension(mimeType);
        String fileName = node.getName();
        if (fileName.lastIndexOf("." + ext) < 0) {
            fileName = fileName + "." + ext;
        }
        dresource.setDownloadName(fileName);
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getTemplatePath() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getTemplatePath(this.getOriginalNode(), false);
    }

    public String getTemplate() {
        try {
            return this.getTemplatePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            String workspace = dmsConfiguration.getConfig(this.repository).getSystemWorkspace();
            this.resourceResolver = new JCRResourceResolver(this.repository, workspace, "exo:templateFile");
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UIMessageBoard.msg.get-template-resource", null, (int)0);
        }
        return this.resourceResolver;
    }

    public String getNodeType() throws Exception {
        return this.getOriginalNode().getPrimaryNodeType().getName();
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public void setNode(Node node) {
        this.contentNodeLocation = NodeLocation.make((Node)node);
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    public UIComponent getCommentComponent() {
        return null;
    }

    public UIComponent getRemoveAttach() throws Exception {
        return null;
    }

    public UIComponent getRemoveComment() throws Exception {
        return null;
    }

    public UIComponent getUIComponent(String mimeType) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        List extensions = manager.getUIExtensions("org.exoplatform.ecm.dms.FileViewer");
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("mimeType", mimeType);
        for (UIExtension extension : extensions) {
            UIComponent uiComponent = manager.addUIExtension(extension, context, (UIContainer)this);
            if (uiComponent == null) continue;
            return uiComponent;
        }
        return null;
    }
}

