/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.JCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.organization.User;

public class UserByGroupJCRUserListAccess
extends JCRUserListAccess {
    private String groupId;

    public UserByGroupJCRUserListAccess(JCROrganizationServiceImpl service, String groupId) {
        super(service);
        this.groupId = groupId;
    }

    protected int getSize(Session session) throws Exception {
        try {
            Node gNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:groups" + this.groupId);
            String statement = "select * from jos:userMembership where jos:group='" + gNode.getUUID() + "'";
            Query mquery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult mres = mquery.execute();
            return (int)mres.getNodes().getSize();
        }
        catch (PathNotFoundException e) {
            return 0;
        }
        catch (RepositoryException e) {
            throw new OrganizationServiceException("Can not get list size", e);
        }
    }

    protected User[] load(Session session, int index, int length) throws Exception {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        try {
            User[] users = new User[length];
            Node gNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "jos:groups" + this.groupId);
            String statement = "select * from jos:userMembership where jos:group='" + gNode.getUUID() + "'";
            Query mquery = session.getWorkspace().getQueryManager().createQuery(statement, "sql");
            QueryResult mres = mquery.execute();
            NodeIterator results = mres.getNodes();
            UserHandlerImpl uHandler = new UserHandlerImpl(this.service);
            int p = 0;
            int counter = 0;
            while (counter < length) {
                if (!results.hasNext()) {
                    throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
                }
                Node result = results.nextNode().getParent();
                if (p >= index) {
                    users[counter++] = uHandler.readObjectFromNode(result);
                }
                ++p;
            }
            return users;
        }
        catch (PathNotFoundException e) {
            return new User[0];
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not load users", e);
        }
    }
}

