/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.ext.BaseStandaloneTest;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditRecord;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionCatalog;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AuditVersionableTest
extends BaseStandaloneTest {
    private static final Log log = ExoLogger.getLogger(AuditVersionableTest.class);
    private Node testRoot;
    private AuditService service;
    private SessionActionCatalog catalog;
    private Session adminSession;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.service = (AuditService)this.container.getComponentInstanceOfType(AuditService.class);
        this.catalog = (SessionActionCatalog)this.session.getContainer().getComponentInstanceOfType(SessionActionCatalog.class);
        this.testRoot = this.root.addNode("AuditServiceTest");
        this.root.save();
    }

    @Override
    protected void tearDown() throws Exception {
        this.testRoot.refresh(false);
        this.testRoot.remove();
        this.root.save();
        super.tearDown();
    }

    public void testAddMixVersionable() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        ExtendedNode node = (ExtendedNode)this.testRoot.addNode("deep");
        this.session.save();
        node.addMixin("mix:versionable");
        this.root.save();
        AuditHistory ah = this.service.getHistory((Node)node);
        for (AuditRecord ar : ah.getAuditRecords()) {
            String vuuid = ar.getVersion();
            AuditVersionableTest.assertNull((String)"Version UUIDs should be null", (Object)vuuid);
        }
    }

    public void testAddProperty() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        ExtendedNode node = (ExtendedNode)this.testRoot.addNode("deep");
        this.session.save();
        node.addMixin("mix:versionable");
        this.root.save();
        node.checkin();
        String v1UUID = node.getBaseVersion().getUUID();
        node.checkout();
        String propName = "prop1";
        InternalQName propQName = new InternalQName("", "prop1");
        node.setProperty("prop1", "prop #1");
        this.root.save();
        node.checkin();
        String v2UUID = node.getBaseVersion().getUUID();
        node.getVersionHistory().addVersionLabel(node.getBaseVersion().getName(), "ver.1.1", false);
        node.checkout();
        node.setProperty("prop1", "prop #1.1");
        AuditHistory ah = this.service.getHistory((Node)node);
        for (AuditRecord ar : ah.getAuditRecords()) {
            String vname;
            String vuuid;
            if (ar.getEventType() == 4 && ar.getPropertyName().equals((Object)propQName)) {
                vuuid = ar.getVersion();
                vname = ar.getVersionName();
                AuditVersionableTest.assertEquals((String)"Version UUIDs should be equals", (String)v1UUID, (String)vuuid);
                continue;
            }
            if (ar.getEventType() != 16 || !ar.getPropertyName().equals((Object)propQName)) continue;
            vuuid = ar.getVersion();
            vname = ar.getVersionName();
            AuditVersionableTest.assertEquals((String)"Version UUIDs should be equals", (String)v2UUID, (String)vuuid);
        }
    }

    public void testVersionableAncestor() throws Exception {
        String vname;
        String vuuid;
        ExtendedNode node = (ExtendedNode)this.testRoot.addNode("deep");
        this.session.save();
        node.addMixin("mix:versionable");
        this.root.save();
        String propName = "prop1";
        InternalQName propQName = new InternalQName("", "prop1");
        node.checkin();
        String v1UUID = node.getBaseVersion().getUUID();
        node.checkout();
        Node node1 = node.addNode("node1");
        node.save();
        node1.setProperty("prop1", "prop #1");
        node1.save();
        node.checkin();
        String v2UUID = node.getBaseVersion().getUUID();
        node.checkout();
        AuditHistory ah = this.service.getHistory(node1);
        for (AuditRecord ar : ah.getAuditRecords()) {
            String vuuid2 = ar.getVersion();
            String vname2 = ar.getVersionName();
            if (ar.getEventType() != 4 || !ar.getPropertyName().equals((Object)propQName)) continue;
            AuditVersionableTest.assertEquals((String)"Version UUIDs should be equals", (String)v1UUID, (String)vuuid2);
        }
        Node node2 = node1.addNode("node2");
        node1.save();
        node2.setProperty("prop1", "prop #2");
        node2.save();
        node.checkin();
        node.checkout();
        ah = this.service.getHistory(node2);
        for (AuditRecord ar : ah.getAuditRecords()) {
            vuuid = ar.getVersion();
            vname = ar.getVersionName();
            if (ar.getEventType() != 4 || !ar.getPropertyName().equals((Object)propQName)) continue;
            AuditVersionableTest.assertEquals((String)"Version UUIDs should be equals", (String)v2UUID, (String)vuuid);
        }
        ah = this.service.getHistory(node1);
        for (AuditRecord ar : ah.getAuditRecords()) {
            vuuid = ar.getVersion();
            vname = ar.getVersionName();
            if (ar.getEventType() != 4 || !ar.getPropertyName().equals((Object)propQName)) continue;
            AuditVersionableTest.assertEquals((String)"Version UUIDs should be equals", (String)v1UUID, (String)vuuid);
        }
    }
}

