/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.util.configuration;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.carol.util.configuration.ConfigurationException;
import org.objectweb.carol.util.configuration.Protocol;
import org.objectweb.carol.util.configuration.ProtocolConfiguration;
import org.objectweb.carol.util.configuration.ProtocolConfigurationImplMBean;

public class ProtocolConfigurationImpl
implements ProtocolConfiguration,
ProtocolConfigurationImplMBean {
    private String name = null;
    private Protocol protocol = null;
    private Properties properties = null;
    private Hashtable jndiEnv = null;
    private String host = null;
    private int port = 0;
    private String objectName = null;

    public ProtocolConfigurationImpl(String name, Protocol protocol, Properties properties) throws ConfigurationException {
        this.name = name;
        this.protocol = protocol;
        this.configure(properties);
    }

    public void configure(Properties properties) throws ConfigurationException {
        if (properties == null) {
            throw new ConfigurationException("Cannot build a configuration with a null properties object");
        }
        this.properties = properties;
        this.extractJNDIProperties();
        this.parseURL();
    }

    protected void extractJNDIProperties() throws ConfigurationException {
        this.jndiEnv = new Hashtable();
        String prefixProtocol = "carol." + this.protocol.getName() + ".";
        this.jndiEnv.put("java.naming.provider.url", this.getValue(prefixProtocol + "url"));
        this.jndiEnv.put("java.naming.factory.initial", this.protocol.getInitialContextFactoryClassName());
    }

    protected void parseURL() throws ConfigurationException {
        String url = this.getProviderURL();
        this.port = this.getPortOfUrl(url);
        this.host = this.getHostOfUrl(url);
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        Hashtable newEnv = (Hashtable)env.clone();
        newEnv.putAll(this.jndiEnv);
        return new InitialContext(newEnv);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        return (Properties)this.properties.clone();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getProviderURL() {
        return (String)this.jndiEnv.get("java.naming.provider.url");
    }

    protected int getPortOfUrl(String url) throws ConfigurationException {
        int portNumber = 0;
        try {
            StringTokenizer st = new StringTokenizer(url, ":");
            st.nextToken();
            st.nextToken();
            if (st.hasMoreTokens()) {
                StringTokenizer lastst = new StringTokenizer(st.nextToken(), "/");
                String pts = lastst.nextToken().trim();
                int i = pts.indexOf(44);
                if (i > 0) {
                    pts = pts.substring(0, i);
                }
                portNumber = new Integer(pts);
            }
            return portNumber;
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid URL '" + url + "'. It should be on the format <protocol>://<hostname>:<port>");
        }
    }

    protected String getHostOfUrl(String url) throws ConfigurationException {
        String host = null;
        try {
            String[] tmpSplitStr = url.split(":");
            String tmpHost = tmpSplitStr[1];
            String[] tmpSplitHost = tmpHost.split("/");
            host = tmpSplitHost[tmpSplitHost.length - 1];
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid URL '" + url + "'. It should be on the format <protocol>://<hostname>:<port>");
        }
        return host;
    }

    protected String getValue(String key) throws ConfigurationException {
        String s = this.properties.getProperty(key);
        if (s == null) {
            throw new ConfigurationException("Property '" + key + "' was not found in the properties object of the protocol, properties are :'" + this.properties + "'");
        }
        return s;
    }

    public Hashtable getJndiEnv() {
        return this.jndiEnv;
    }

    public String getInitialContextFactoryClassName() {
        return this.protocol.getInitialContextFactoryClassName();
    }

    public List getNames() throws NamingException {
        Context ctx = this.getInitialContext(this.getJndiEnv());
        ArrayList<String> names = new ArrayList<String>();
        NamingEnumeration<NameClassPair> ne = ctx.list("");
        String n = null;
        while (ne.hasMore()) {
            NameClassPair ncp = ne.next();
            n = ncp.getName();
            names.add(n);
        }
        return names;
    }

    public String getobjectName() {
        return this.objectName;
    }

    public void setobjectName(String name) {
        this.objectName = name;
    }

    public boolean iseventProvider() {
        return false;
    }

    public boolean isstateManageable() {
        return false;
    }

    public boolean isstatisticsProvider() {
        return false;
    }
}

