/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.UID;
import java.util.Arrays;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorStore;
import org.objectweb.carol.rmi.jrmp.server.JLocalObjectStore;
import org.objectweb.carol.rmi.jrmp.server.JRemoteCall;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.Connection;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.StreamRemoteCall;

public class JUnicastRef
extends UnicastRef {
    private transient boolean localRef = false;
    private transient byte[] raddr = null;
    private transient UID ruid = null;
    protected transient JClientRequestInterceptor[] cis = null;
    protected transient String[] initializers = null;
    private transient int localId = -2;

    public JUnicastRef() {
    }

    public JUnicastRef(LiveRef liveRef) {
        super(liveRef);
    }

    public JUnicastRef(LiveRef liveRef, JClientRequestInterceptor[] cis, String[] initial, int local) {
        super(liveRef);
        this.initializers = initial;
        this.cis = cis;
        this.raddr = JInterceptorHelper.getInetAddress();
        this.ruid = JInterceptorHelper.getSpaceID();
        this.localId = local;
    }

    public String getRefClass(ObjectOutput out) {
        super.getRefClass(out);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Remote obj, Method method, Object[] params, long opnum) throws Exception {
        Object object;
        boolean alreadyFreed;
        boolean reuse;
        Connection conn;
        block28: {
            Class<?>[] types;
            block27: {
                if (this.localRef && this.localId != -2) {
                    return method.invoke(JLocalObjectStore.getObject(this.localId), params);
                }
                conn = this.ref.getChannel().newConnection();
                JRemoteCall call = null;
                reuse = true;
                alreadyFreed = false;
                try {
                    try {
                        call = new JRemoteCall(conn, this.ref.getObjID(), -1, opnum, this.cis);
                        try {
                            ObjectOutput out = call.getOutputStream();
                            this.marshalCustomCallData(out);
                            types = method.getParameterTypes();
                            for (int i = 0; i < types.length; ++i) {
                                JUnicastRef.marshalValue(types[i], params[i], out);
                            }
                        }
                        catch (IOException e) {
                            throw new MarshalException("error marshalling arguments" + e);
                        }
                        call.executeCall();
                        try {
                            Class<?> rtype = method.getReturnType();
                            if (rtype == Void.TYPE) {
                                types = null;
                                Object var18_20 = null;
                                if (alreadyFreed) return types;
                                break block27;
                            }
                            ObjectInput in = call.getInputStream();
                            Object returnValue = JUnicastRef.unmarshalValue(rtype, in);
                            alreadyFreed = true;
                            this.ref.getChannel().free(conn, true);
                            object = returnValue;
                            break block28;
                        }
                        catch (IOException e) {
                            throw new UnmarshalException("IOException unmarshalling return" + e);
                        }
                        catch (ClassNotFoundException e) {
                            throw new UnmarshalException("ClassNotFoundException unmarshalling return" + e);
                        }
                        finally {
                            try {
                                call.done();
                            }
                            catch (IOException e) {
                                reuse = false;
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        if (call != null) {
                            if (((StreamRemoteCall)call).getServerException() == e) throw e;
                        }
                        reuse = false;
                        throw e;
                    }
                    catch (RemoteException e) {
                        reuse = false;
                        throw e;
                    }
                    catch (Error e) {
                        reuse = false;
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var18_22 = null;
                    if (alreadyFreed) throw throwable;
                    this.ref.getChannel().free(conn, reuse);
                    throw throwable;
                }
            }
            this.ref.getChannel().free(conn, reuse);
            return types;
        }
        Object var18_21 = null;
        if (alreadyFreed) return object;
        this.ref.getChannel().free(conn, reuse);
        return object;
    }

    public void invoke(RemoteCall call) throws Exception {
        super.invoke(call);
    }

    public RemoteCall newCall(RemoteObject obj, Operation[] ops, int opnum, long hash) throws RemoteException {
        Connection conn = this.ref.getChannel().newConnection();
        try {
            JRemoteCall call = new JRemoteCall(conn, this.ref.getObjID(), opnum, hash, this.cis);
            try {
                this.marshalCustomCallData(call.getOutputStream());
            }
            catch (IOException e) {
                throw new MarshalException("error marshaling custom call data");
            }
            return call;
        }
        catch (RemoteException e) {
            this.ref.getChannel().free(conn, false);
            throw e;
        }
    }

    protected void marshalCustomCallData(ObjectOutput out) throws IOException {
        JClientInterceptorHelper.send_request(out, this.cis, this.localRef);
        super.marshalCustomCallData(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in, false);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal(out, false);
    }

    public void readExternal(ObjectInput in, boolean newFormat) throws IOException, ClassNotFoundException {
        this.raddr = new byte[in.readInt()];
        in.read(this.raddr);
        this.ruid = UID.read(in);
        this.localRef = Arrays.equals(this.raddr, JInterceptorHelper.getInetAddress()) && this.ruid.equals(JInterceptorHelper.getSpaceID());
        String[] ia = new String[in.readInt()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = in.readUTF();
        }
        this.initializers = ia;
        this.cis = JInterceptorStore.setRemoteInterceptors(this.raddr, this.ruid, ia);
        this.localId = in.readInt();
        this.ref = LiveRef.read(in, newFormat);
    }

    public void writeExternal(ObjectOutput out, boolean newFormat) throws IOException {
        out.writeInt(this.raddr.length);
        out.write(this.raddr);
        this.ruid.write(out);
        String[] ia = this.initializers;
        out.writeInt(ia.length);
        for (int i = 0; i < ia.length; ++i) {
            out.writeUTF(ia[i]);
        }
        out.writeInt(this.getLocalId());
        this.ref.write(out, newFormat);
        out.flush();
    }

    public int getLocalId() {
        return this.localId;
    }
}

