/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.csiv2.struct;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.omg.CSIIOP.TransportAddress;
import org.ow2.carol.util.configuration.TraceCarol;

public class TransportStruct
implements Serializable {
    private static final long serialVersionUID = -6464356863301808208L;
    private static final String LOCAL_IP = "127.0.0.1";
    private TransportAddress[] transportAdresses = null;
    private short targetSupports = 0;
    private short targetRequires = 0;

    public static int getSslPort() {
        String sslPortStr = System.getProperty("OASSLPort", String.valueOf(2003));
        return Integer.parseInt(sslPortStr);
    }

    public TransportAddress[] getTransportAddress() {
        int sslPort = TransportStruct.getSslPort();
        String ipAddr = null;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ipAddr = addr.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            TraceCarol.error("Cannot get current hostname", uhe);
            ipAddr = LOCAL_IP;
        }
        this.transportAdresses = new TransportAddress[1];
        this.transportAdresses[0] = new TransportAddress(ipAddr, (short)sslPort);
        return this.transportAdresses;
    }

    public void setTargetRequires(int targetRequires) {
        this.targetRequires = (short)targetRequires;
    }

    public void setTargetSupports(int targetSupports) {
        this.targetSupports = (short)targetSupports;
    }

    public short getTargetRequires() {
        return this.targetRequires;
    }

    public short getTargetSupports() {
        return this.targetSupports;
    }
}

