/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.spi;

import java.io.Serializable;
import java.rmi.Remote;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.ow2.carol.jndi.ns.IIOPCosNaming;
import org.ow2.carol.jndi.spi.AbsContext;
import org.ow2.carol.jndi.wrapping.JNDIReferenceWrapper;
import org.ow2.carol.jndi.wrapping.JNDIRemoteResource;
import org.ow2.carol.jndi.wrapping.JNDIResourceWrapper;
import org.ow2.carol.jndi.wrapping.RemoteReference;
import org.ow2.carol.rmi.exception.NamingExceptionHelper;
import org.ow2.carol.util.configuration.ConfigurationRepository;

public class IIOPContext
extends AbsContext
implements Context {
    private static POA rootPOA = null;

    public IIOPContext(Context iiopCtx) throws NamingException {
        super(iiopCtx);
        ORB orb = IIOPCosNaming.getOrb();
        if (rootPOA == null) {
            try {
                rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            }
            catch (Exception e) {
                throw NamingExceptionHelper.create("Cannot get a single instance" + e.getMessage(), e);
            }
        }
    }

    protected java.lang.Object unwrapObject(java.lang.Object o, Name name) throws NamingException {
        try {
            if (o instanceof RemoteReference) {
                Reference objRef = ((RemoteReference)o).getReference();
                ObjectFactory objFact = (ObjectFactory)Class.forName(objRef.getFactoryClassName()).newInstance();
                return objFact.getObjectInstance(objRef, name, this, this.getEnvironment());
            }
            if (o instanceof JNDIRemoteResource) {
                return ((JNDIRemoteResource)o).getResource();
            }
            return o;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot unwrap object '" + o + "' with name '" + name + "' :" + e.getMessage(), e);
        }
    }

    protected java.lang.Object wrapObject(java.lang.Object o, Name name, boolean replace) throws NamingException {
        try {
            Remote wrappedObject = null;
            if (!(o instanceof Remote) && o instanceof Referenceable) {
                wrappedObject = new JNDIReferenceWrapper(((Referenceable)o).getReference());
            } else if (!(o instanceof Remote) && o instanceof Reference) {
                wrappedObject = new JNDIReferenceWrapper((Reference)o);
            } else if (!(o instanceof Remote) && o instanceof Serializable) {
                wrappedObject = new JNDIResourceWrapper((Serializable)o);
            } else {
                return o;
            }
            PortableRemoteObjectDelegate proDelegate = ConfigurationRepository.getCurrentConfiguration().getProtocol().getPortableRemoteObject();
            proDelegate.exportObject(wrappedObject);
            Remote oldObj = (Remote)this.addToExported(name, wrappedObject);
            if (oldObj != null) {
                if (replace) {
                    proDelegate.unexportObject(oldObj);
                } else {
                    proDelegate.unexportObject(wrappedObject);
                    this.addToExported(name, oldObj);
                    throw new NamingException("Object '" + o + "' with name '" + name + "' is already bind");
                }
            }
            return wrappedObject;
        }
        catch (Exception e) {
            throw NamingExceptionHelper.create("Cannot wrap object '" + o + "' with name '" + name + "' : " + e.getMessage(), e);
        }
    }
}

