/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQServiceUtils;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.faq.service.Watch;

public class Utils {
    public static final String FAQ_APP = "faqApp".intern();
    public static final String DEFAULT_AVATAR_URL = "/social-resources/skin/images/ShareImages/UserAvtDefault.png";
    public static final String QUESTION_HOME = "questions".intern();
    public static final String CATEGORY_HOME = "categories";
    public static final String ANSWER_HOME = "faqAnswerHome".intern();
    public static final String COMMENT_HOME = "faqCommentHome".intern();
    public static final String LANGUAGE_HOME = "languages".intern();
    public static final String ALL = "All".intern();
    public static final String CATE_SPACE_ID_PREFIX = "CategorySpace".intern();
    public static final String UI_FAQ_VIEWER = "UIFAQViewer".intern();
    public static final String DELETED = ":deleted".intern();
    public static final String HYPHEN = "-".intern();
    public static final String QUESTION_ID_PARAM = "questionId";
    public static final String ANSWER_NOW_PARAM = "answer-now";
    public static final String QUESTION_ID = String.format("?&%s=", "questionId");
    public static final String ANSWER_NOW = String.format("&%s=", "answer-now");
    public static final String HIGHLIGHT_PATTERN = "(.*)<strong>(.*)</strong>(.*)";

    public static boolean hasPermission(List<String> listPlugin, List<String> listOfUser) {
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> groupsAllmembershipType = new ArrayList<String>();
        for (String str : listOfUser) {
            if (str.indexOf("/") >= 0) {
                groups.add(str.substring(str.indexOf("/")));
            }
            if (str.indexOf("*") >= 0) {
                str = str.substring(str.indexOf("/"));
                groupsAllmembershipType.add(str);
            }
            if (!listPlugin.contains(str)) continue;
            return true;
        }
        if (groups.size() > 0 || groupsAllmembershipType.size() > 0) {
            for (String str : listPlugin) {
                if (str.indexOf("*") >= 0 && groups.contains(str = str.substring(str.indexOf("/")))) {
                    return true;
                }
                if (str.indexOf(":") > 0) {
                    str = str.substring(str.indexOf("/"));
                }
                if (!groupsAllmembershipType.contains(str)) continue;
                return true;
            }
        }
        return false;
    }

    public static long getTimeOfLastActivity(String info) {
        if (info == null || info.length() == 0) {
            return -1L;
        }
        int dashIndex = info.lastIndexOf(HYPHEN);
        if (dashIndex < 0) {
            return -1L;
        }
        try {
            return Long.parseLong(info.substring(dashIndex + 1));
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static String getAuthorOfLastActivity(String info) {
        if (info == null || info.length() == 0) {
            return null;
        }
        int dashIndex = info.lastIndexOf(HYPHEN);
        if (dashIndex < 0) {
            return null;
        }
        return info.substring(0, dashIndex);
    }

    public static String getOderBy(FAQSetting faqSetting) {
        StringBuffer queryString = new StringBuffer();
        if (faqSetting.isSortQuestionByVote()) {
            queryString.append("@").append("exo:markVote").append(FAQSetting.ORDERBY_DESC).append(", ");
        }
        if (faqSetting.getOrderBy().equals(FAQSetting.DISPLAY_TYPE_POSTDATE)) {
            queryString.append("@").append("exo:createdDate");
        } else {
            queryString.append("@").append("exo:title");
        }
        if (faqSetting.getOrderType().equals(FAQSetting.ORDERBY_TYPE_ASC)) {
            queryString.append(FAQSetting.ORDERBY_ASC);
        } else {
            queryString.append(FAQSetting.ORDERBY_DESC);
        }
        return queryString.toString();
    }

    public static String buildQueryListOfUser(String property, List<String> listOfUser) {
        StringBuilder query = new StringBuilder();
        for (String expr : listOfUser) {
            if (query.length() > 0) {
                query.append(" or ");
            }
            query.append("@").append(property).append(" = '").append(expr).append("'");
            if (FAQServiceUtils.isGroupExpression(expr)) {
                query.append(" or @").append(property).append(" = '*:").append(expr).append("'");
                continue;
            }
            if (!FAQServiceUtils.isMembershipExpression(expr)) continue;
            expr = expr.substring(expr.indexOf(":") + 1);
            query.append(" or @").append(property).append(" = '*:").append(expr).append("'");
        }
        return query.toString();
    }

    public static class NameComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Watch)o1).getUser();
            String name2 = ((Watch)o2).getUser();
            return name1.compareToIgnoreCase(name2);
        }
    }

    public static class NameComparatorDESC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Category)o1).getName();
            String name2 = ((Category)o2).getName();
            return name2.compareToIgnoreCase(name1);
        }
    }

    public static class DatetimeComparatorDESC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            Date date1 = ((Category)o1).getCreatedDate();
            Date date2 = ((Category)o2).getCreatedDate();
            return date2.compareTo(date1);
        }
    }

    public static class NameComparatorASC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Category)o1).getName();
            String name2 = ((Category)o2).getName();
            return name1.compareToIgnoreCase(name2);
        }
    }

    public static class DatetimeComparatorASC
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) throws ClassCastException {
            Date date1 = ((Category)o1).getCreatedDate();
            Date date2 = ((Category)o2).getCreatedDate();
            return date1.compareTo(date2);
        }
    }
}

