/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.answer.rendering.RenderHelper;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.CategoryInfo;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.FAQResourceResolver;
import org.exoplatform.faq.webui.UIViewer;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(events={@EventConfig(listeners={ChangePathActionListener.class})})
public class UIViewer
extends UIContainer {
    private FAQService fAqService;
    private String path = "categories";
    protected boolean useAjax = false;
    private boolean isInSpace = false;
    private RenderHelper renderHelper = new RenderHelper();

    public UIViewer() {
        this.fAqService = (FAQService)PortalContainer.getComponent(FAQService.class);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        super.processDecode(context);
        this.setPath("");
    }

    public String getPath() {
        return this.path;
    }

    public boolean isInSpace() {
        return this.isInSpace;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected List<String> arrangeList(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>();
        if (list.isEmpty() || list.size() == 0) {
            newList.add("<img src=\"/answer/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"categories\"/>");
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (i == list.size() - 1) {
                    newList.add("<img src=\"/answer/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"" + list.get(i) + "\"/>");
                    continue;
                }
                newList.add(list.get(i));
            }
        }
        return newList;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return new FAQResourceResolver();
    }

    public String getTemplate() {
        return "FAQViewerTemplate";
    }

    protected CategoryInfo getCategoryInfo() throws Exception {
        this.useAjax = FAQUtils.getUseAjaxFAQPortlet();
        this.isInSpace = this.path.indexOf(Utils.CATE_SPACE_ID_PREFIX) >= 0;
        return this.fAqService.getCategoryInfo(this.path, FAQUtils.getCategoriesIdFAQPortlet());
    }

    protected String render(String s) {
        Question question = new Question();
        question.setDetail(s);
        return this.renderHelper.renderQuestion(question);
    }
}

