/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.popup.UIFAQSettingForm;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.UIViewer;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/faq/webui/UIFAQPortlet.gtmpl")
public class UIFAQPortlet
extends UIPortletApplication {
    private static final String SLASH = "/".intern();

    public UIFAQPortlet() throws Exception {
        this.addChild(UIViewer.class, null, null);
    }

    public String getDisplaySpaceName() {
        PortalRequestContext plcontext = Util.getPortalRequestContext();
        String requestPath = plcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            return null;
        }
        String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        if (spacePrettyName != null) {
            SpaceService sService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = sService.getSpaceByPrettyName(spacePrettyName);
            return space != null ? space.getDisplayName() : CommonUtils.AMP_SPACE;
        }
        return CommonUtils.AMP_SPACE;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            this.removeChild(UIFAQSettingForm.class);
            UIViewer uiViewer = (UIViewer)this.getChild(UIViewer.class);
            if (uiViewer == null) {
                uiViewer = (UIViewer)((UIViewer)this.addChild(UIViewer.class, null, null)).setRendered(true);
            }
            if (FAQUtils.isFieldEmpty((String)context.getRequestParameter("objectId")) && !context.getParentAppRequestContext().useAjax() && "".equals(uiViewer.getPath())) {
                uiViewer.setPath(this.getPathOfCateSpace());
            }
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            this.removeChild(UIViewer.class);
            if (this.getChild(UIFAQSettingForm.class) == null) {
                UIFAQSettingForm settingForm = (UIFAQSettingForm)this.addChild(UIFAQSettingForm.class, null, null);
                settingForm.defaulValue();
            }
        }
        super.processRender(app, context);
    }

    public String getPathOfCateSpace() {
        try {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences pref = pcontext.getRequest().getPreferences();
            String url = pref.getValue("SPACE_URL", null);
            if (url != null) {
                SpaceService sService = (SpaceService)this.getApplicationComponent(SpaceService.class);
                FAQService fService = (FAQService)this.getApplicationComponent(FAQService.class);
                Space space = sService.getSpaceByUrl(url);
                String pathOfCateSpace = "categories" + SLASH + Utils.CATE_SPACE_ID_PREFIX + space.getPrettyName();
                if (fService.isExisting(pathOfCateSpace)) {
                    return pathOfCateSpace;
                }
            }
            return "categories";
        }
        catch (Exception e) {
            return "categories";
        }
    }
}

