/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import org.exoplatform.answer.webui.BaseUIFAQForm;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.UIAnswersContainer;
import org.exoplatform.answer.webui.UIAnswersPortlet;
import org.exoplatform.answer.webui.UICategories;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQSetting;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/answer/webui/UICategories.gtmpl", events={@EventConfig(listeners={AddCategoryActionListener.class}), @EventConfig(listeners={AddNewQuestionActionListener.class}), @EventConfig(listeners={EditCategoryActionListener.class}), @EventConfig(listeners={DeleteCategoryActionListener.class}, confirm="UIQuestions.msg.confirm-delete-category"), @EventConfig(listeners={MoveCategoryActionListener.class}), @EventConfig(listeners={WatchActionListener.class}), @EventConfig(listeners={WatchManagerActionListener.class}), @EventConfig(listeners={UnWatchActionListener.class}), @EventConfig(listeners={ExportActionListener.class}), @EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={ChangeIndexActionListener.class}), @EventConfig(listeners={OpenCategoryActionListener.class}), @EventConfig(listeners={FilterQuestionsActionListener.class}), @EventConfig(listeners={MoveCategoryIntoActionListener.class})})
public class UICategories
extends BaseUIFAQForm {
    private static final Log log = ExoLogger.getLogger(UICategories.class);
    private String FILTER_OPEN_QUESTIONS = "openQuestions";
    private String FILTER_PENDING_QUESTIONS = "pendingQuestions";
    public String parentCateID_ = null;
    private String categoryId_;
    private boolean isSwap = false;
    private String currentCategoryName = "";
    private List<Category> listCate = new ArrayList();
    private Map<String, Boolean> categoryMod = new HashMap();
    private Map<String, String> categoryIds = new HashMap();
    private boolean isModerator = false;
    private FAQSetting faqSetting_ = new FAQSetting();
    private String[] firstActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "Watch"};
    private String[] firstActionCateUnWatch_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "UnWatch"};
    private String[] secondActionCate_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "Watch"};
    private String[] secondActionCateUnWatch_ = new String[]{"Export", "Import", "AddCategory", "AddNewQuestion", "EditCategory", "DeleteCategory", "MoveCategory", "UnWatch"};
    private String[] userActionsCate_ = new String[]{"AddNewQuestion", "Watch"};
    private String[] userActionsCateUnWatch_ = new String[]{"AddNewQuestion", "UnWatch"};
    private String portalName = null;
    private String[] font_weight = new String[]{"bold", "none", "none"};

    public UICategories() throws Exception {
        this.portalName = this.getPortalName();
    }

    public void setFAQSetting(FAQSetting faqSetting) {
        this.faqSetting_ = faqSetting;
    }

    protected boolean isShowInfo() {
        return ((UIAnswersContainer)this.getParent()).getRenderChild();
    }

    protected long[] getCategoryInfo() {
        long[] result = new long[]{0L, 0L, 0L, 0L};
        try {
            boolean canEdit = this.faqSetting_.isCanEdit();
            this.faqSetting_.setCanEdit(this.isModerator);
            result = this.getFAQService().getCategoryInfo(this.categoryId_, this.faqSetting_);
            this.faqSetting_.setCanEdit(canEdit);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get category info,", (Throwable)e);
        }
        return result;
    }

    protected List<Category> getListCate() {
        return this.listCate;
    }

    public String getCategoryPath() {
        return this.categoryId_;
    }

    public void setPathCategory(String categoryPath) {
        this.categoryId_ = categoryPath;
        this.parentCateID_ = categoryPath.indexOf("/") >= 0 ? categoryPath.substring(0, categoryPath.lastIndexOf("/")) : "categories";
        this.font_weight = new String[]{"bold", "none", "none"};
    }

    private void setIsModerators() throws Exception {
        this.categoryMod.clear();
        this.isModerator = false;
        if (this.faqSetting_.isAdmin()) {
            this.isModerator = true;
        }
        if (!this.isModerator) {
            this.isModerator = this.getFAQService().isCategoryModerator(this.categoryId_, null);
        }
        if (!this.isModerator) {
            for (Category cat : this.listCate) {
                this.categoryMod.put(cat.getId(), this.getFAQService().isCategoryModerator(cat.getPath(), null));
            }
        }
    }

    protected boolean isCategoryModerator(String path) throws Exception {
        if (this.faqSetting_.isAdmin()) {
            return true;
        }
        if (!FAQUtils.isFieldEmpty((String)this.categoryId_) && path.indexOf(this.categoryId_) >= 0 && this.isModerator) {
            return true;
        }
        String categoryId = path;
        if (categoryId.indexOf("/") > 0) {
            categoryId = categoryId.substring(categoryId.lastIndexOf("/") + 1);
        }
        if (this.categoryMod.containsKey(categoryId)) {
            return (Boolean)this.categoryMod.get(categoryId);
        }
        boolean isMod = this.getFAQService().isCategoryModerator(path, null);
        this.categoryMod.put(categoryId, isMod);
        return isMod;
    }

    public String getCurrentName() {
        return this.currentCategoryName;
    }

    private boolean isWatched(String cateId) {
        return this.getFAQService().isUserWatched(this.faqSetting_.getCurrentUser(), cateId);
    }

    protected boolean hasWatch(String categoryPath) {
        return this.getFAQService().hasWatch(categoryPath);
    }

    private void checkAndSetListCategory(String categoryId) throws Exception {
        this.listCate = new ArrayList();
        FAQSetting faqSetting = new FAQSetting();
        boolean isAdmin = this.faqSetting_.isAdmin();
        if (!isAdmin) {
            isAdmin = this.isModerator;
        }
        faqSetting.setIsAdmin(String.valueOf(isAdmin));
        List list = this.getFAQService().getSubCategories(categoryId, faqSetting, true, null);
        for (Category category : list) {
            if (!FAQUtils.hasPermission((Category)category)) continue;
            this.listCate.add(category);
            this.categoryIds.put(category.getId(), category.getPath());
        }
    }

    protected void setListCate() throws Exception {
        if (!this.isSwap) {
            this.setIsModerators();
            try {
                this.checkAndSetListCategory(this.categoryId_);
            }
            catch (PathNotFoundException e) {
                this.setPathCategory(this.parentCateID_);
                this.checkAndSetListCategory(this.categoryId_);
            }
            catch (Exception e) {
                log.debug((Object)"Failed to get list sub-categories in category", (Throwable)e);
            }
            if (this.categoryId_.equals("categories")) {
                this.currentCategoryName = this.getFAQService().getCategoryById(this.categoryId_).getName();
                this.currentCategoryName = "<img src=\"/faq/skin/DefaultSkin/webui/background/HomeIcon.gif\" alt=\"" + this.currentCategoryName + "\"/>";
            } else {
                this.currentCategoryName = this.getFAQService().getCategoryById(this.categoryId_).getName();
            }
            if (this.currentCategoryName == null || this.currentCategoryName.trim().length() < 1) {
                this.currentCategoryName = WebUIUtils.getLabel(null, (String)"UIBreadcumbs.label.categories");
            }
        }
        this.isSwap = false;
    }

    public String getRSSLink(String cateId) {
        cateId = cateId.substring(cateId.lastIndexOf("/") + 1);
        return CommonUtils.getRSSLink((String)"faq", (String)this.portalName, (String)cateId);
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public void resetListCate() throws Exception {
        this.isSwap = true;
        this.setIsModerators();
        this.checkAndSetListCategory(this.parentCateID_);
    }

    protected String[] getActionCategory(String cateId) {
        if (this.categoryId_ == null) {
            if (this.isWatched(cateId)) {
                return this.firstActionCateUnWatch_;
            }
            return this.firstActionCate_;
        }
        if (this.isWatched(cateId)) {
            return this.secondActionCateUnWatch_;
        }
        return this.secondActionCate_;
    }

    protected String[] getActionCategoryWithUser(String cateId) {
        try {
            if (FAQUtils.getCurrentUser() != null) {
                if (this.isWatched(cateId)) {
                    return this.userActionsCateUnWatch_;
                }
                return this.userActionsCate_;
            }
            return new String[]{this.userActionsCate_[0]};
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get actions in category by user", (Throwable)e);
            return new String[]{this.userActionsCate_[0]};
        }
    }

    private void showMessageQuestionDeleted(WebuiRequestContext context) throws Exception {
        UIAnswersPortlet answerPortlet = (UIAnswersPortlet)this.getAncestorOfType(UIAnswersPortlet.class);
        context.getUIApplication().addMessage(new ApplicationMessage("UIQuestions.msg.category-id-deleted", null, 1));
        context.addUIComponentToUpdateByAjax((UIComponent)answerPortlet);
    }

    private String getSubPathCategoryById(String categoryId) {
        String subCateId = (String)this.categoryIds.get(categoryId);
        if (FAQUtils.isFieldEmpty((String)subCateId)) {
            subCateId = categoryId;
        }
        return subCateId;
    }

    static /* synthetic */ void access$000(UICategories x0, WebuiRequestContext x1) throws Exception {
        x0.showMessageQuestionDeleted(x1);
    }

    static /* synthetic */ FAQSetting access$100(UICategories x0) {
        return x0.faqSetting_;
    }

    static /* synthetic */ UIComponent access$200(UICategories x0, Class x1, String x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ UIComponent access$300(UICategories x0, Class x1, String x2, int x3, int x4) throws Exception {
        return x0.openPopup(x1, x2, x3, x4);
    }

    static /* synthetic */ String access$400(UICategories x0) {
        return x0.categoryId_;
    }

    static /* synthetic */ Log access$500() {
        return log;
    }

    static /* synthetic */ String access$600(UICategories x0, String x1) {
        return x0.getSubPathCategoryById(x1);
    }

    static /* synthetic */ void access$700(UICategories x0, String x1) {
        x0.warning(x1);
    }

    static /* synthetic */ void access$800(UICategories x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ String access$900(UICategories x0) {
        return x0.FILTER_OPEN_QUESTIONS;
    }

    static /* synthetic */ boolean access$1000(UICategories x0) {
        return x0.isModerator;
    }

    static /* synthetic */ String access$1100(UICategories x0) {
        return x0.FILTER_PENDING_QUESTIONS;
    }

    static /* synthetic */ String[] access$1200(UICategories x0) {
        return x0.font_weight;
    }

    static /* synthetic */ void access$1300(UICategories x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$1400(UICategories x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }

    static /* synthetic */ void access$1500(UICategories x0, String x1, boolean x2) {
        x0.warning(x1, x2);
    }
}

