/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.answer.webui.SelectItem;
import org.exoplatform.answer.webui.SelectOption;
import org.exoplatform.answer.webui.SelectOptionGroup;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;

public class UIFormSelectBoxWithGroups
extends UIFormStringInput {
    private boolean isMultiple_ = false;
    private int size_ = 1;
    private List<SelectItem> options_;
    private String onchange_;

    public UIFormSelectBoxWithGroups(String name, String bindingExpression, List<SelectItem> options) {
        super(name, bindingExpression, null);
        this.setOptions(options);
    }

    public final UIFormSelectBoxWithGroups setMultiple(boolean bl) {
        this.isMultiple_ = bl;
        return this;
    }

    public final UIFormSelectBoxWithGroups setSize(int i) {
        this.size_ = i;
        return this;
    }

    public UIFormSelectBoxWithGroups setValue(String value) {
        this.value_ = value;
        for (SelectItem option : this.options_) {
            if (option instanceof SelectOption) {
                if (((SelectOption)option).getValue().equals(this.value_)) {
                    ((SelectOption)option).setSelected(true);
                    continue;
                }
                ((SelectOption)option).setSelected(false);
                continue;
            }
            if (!(option instanceof SelectOptionGroup)) continue;
            ((SelectOptionGroup)option).setValue(value);
        }
        return this;
    }

    public String[] getSelectedValues() {
        if (this.isMultiple_) {
            ArrayList<String> selectedValues = new ArrayList<String>();
            for (SelectItem option : this.options_) {
                if (option instanceof SelectOption) {
                    if (!((SelectOption)option).isSelected()) continue;
                    selectedValues.add(((SelectOption)option).getValue());
                    continue;
                }
                if (!(option instanceof SelectOptionGroup)) continue;
                selectedValues.addAll(((SelectOptionGroup)option).getSelectedValues());
            }
            return selectedValues.toArray(new String[0]);
        }
        return new String[]{(String)this.value_};
    }

    public UIFormSelectBoxWithGroups setSelectedValues(String[] values) {
        block0: for (SelectItem option : this.options_) {
            if (option instanceof SelectOption) {
                ((SelectOption)option).setSelected(false);
                for (String value : values) {
                    if (!value.equals(((SelectOption)option).getValue())) continue;
                    ((SelectOption)option).setSelected(true);
                    continue block0;
                }
                continue;
            }
            if (!(option instanceof SelectOptionGroup)) continue;
            ((SelectOptionGroup)option).setSelectedValue(values);
        }
        return this;
    }

    public final List<SelectItem> getOptions() {
        return this.options_;
    }

    public final UIFormSelectBoxWithGroups setOptions(List<SelectItem> options) {
        this.options_ = options;
        if (this.options_ == null || this.options_.size() < 1) {
            return this;
        }
        for (SelectItem option : this.options_) {
            if (!(option instanceof SelectOption)) continue;
            this.value_ = ((SelectOption)option).getValue();
            break;
        }
        return this;
    }

    public UIFormSelectBoxWithGroups addOptionGroup(String label, List<SelectOption> options) {
        SelectOptionGroup group = new SelectOptionGroup(label);
        group.setOptions(options);
        this.options_.add(group);
        return this;
    }

    public void reset() {
        if (this.options_ == null || this.options_.size() < 1) {
            return;
        }
        for (SelectItem option : this.options_) {
            if (option instanceof SelectOption) {
                ((SelectOption)option).setSelected(false);
                continue;
            }
            if (!(option instanceof SelectOptionGroup)) continue;
            ((SelectOptionGroup)option).reset();
        }
        for (SelectItem option : this.options_) {
            if (!(option instanceof SelectOption)) continue;
            this.value_ = ((SelectOption)option).getValue();
            ((SelectOption)option).setSelected(true);
            break;
        }
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    public UIFormSelectBoxWithGroups setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public void decode(Object input, WebuiRequestContext context) {
        String[] values = context.getRequestParameterValues(this.getId());
        if (values == null) {
            this.value_ = null;
            for (SelectItem option : this.options_) {
                if (option instanceof SelectOption) {
                    ((SelectOption)option).setSelected(false);
                    continue;
                }
                if (!(option instanceof SelectOptionGroup)) continue;
                for (SelectOption opt : ((SelectOptionGroup)option).getOptions()) {
                    opt.setSelected(false);
                }
            }
            return;
        }
        int i = 0;
        this.value_ = values[0];
        for (SelectItem item : this.options_) {
            if (item instanceof SelectOption) {
                if (i > -1 && ((SelectOption)item).getValue().equals(values[i])) {
                    ((SelectOption)item).setSelected(true);
                    if (values.length != ++i) continue;
                    i = -1;
                    continue;
                }
                ((SelectOption)item).setSelected(false);
                continue;
            }
            if (!(item instanceof SelectOptionGroup)) continue;
            for (SelectOption opt : ((SelectOptionGroup)item).getOptions()) {
                if (i > -1 && opt.getValue().equals(values[i])) {
                    opt.setSelected(true);
                    if (values.length != ++i) continue;
                    i = -1;
                    continue;
                }
                opt.setSelected(false);
            }
        }
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        return uiForm.event(this.onchange_, (String)null);
    }

    protected UIForm getFrom() {
        return (UIForm)this.getAncestorOfType(UIForm.class);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        ResourceBundle res = context.getApplicationResourceBundle();
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String formId = null;
        formId = uiForm.getId().equals("UISearchForm") ? uiForm.getParent().getId() : uiForm.getId();
        Writer w = context.getWriter();
        w.write("<select class=\"selectbox\" id=\"");
        w.write(this.getId());
        w.write("\" name=\"");
        w.write(this.name);
        w.write("\"");
        this.renderHTMLAttributes(w);
        if (this.onchange_ != null) {
            w.append(" onchange=\"").append(this.renderOnChangeEvent(uiForm)).append("\"");
        }
        if (this.isMultiple_) {
            w.write(" multiple=\"true\"");
        }
        if (this.size_ > 1) {
            w.write(" size=\"" + this.size_ + "\"");
        }
        if (this.isDisabled()) {
            w.write(" disabled ");
        }
        w.write(">\n");
        for (SelectItem item : this.options_) {
            String label = item.getLabel();
            if (item instanceof SelectOption) {
                w.write(this.renderOption((SelectOption)item, label));
                continue;
            }
            if (!(item instanceof SelectOptionGroup)) continue;
            try {
                label = res.getString(this.getFrom().getId() + ".optionGroup.label." + label);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
            w.write("<optgroup label=\"");
            w.write(label);
            w.write("\">\n");
            for (SelectOption opt : ((SelectOptionGroup)item).getOptions()) {
                label = opt.getLabel();
                try {
                    label = res.getString(formId + ".label.option." + opt.getValue());
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
                w.write(this.renderOption(opt, label));
            }
            w.write("</optgroup>\n");
        }
        w.write("</select>\n");
        if (this.isMandatory()) {
            w.write(" *");
        }
    }

    private String renderOption(SelectOption option, String label) {
        StringBuffer buf = new StringBuffer();
        buf.append("<option value=\"");
        buf.append(option.getValue());
        buf.append("\"");
        if (option.isSelected()) {
            buf.append("selected=\"selected\"");
        }
        buf.append(">");
        buf.append(label);
        buf.append("</option>\n");
        return buf.toString();
    }
}

