/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.answer.webui.popup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.answer.webui.BaseUIFAQForm;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.CategoryTree;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.input.UICheckBoxInput;

public class BaseCategoryTreeInputForm
extends BaseUIFAQForm {
    public static final String CATEGORY_SCOPING = "CategoryScoping";
    protected Map<String, Boolean> categoryStatus = new HashMap();
    protected Map<String, String> categoryMap = new HashMap();
    protected List<String> categoriesChecked = null;
    protected CategoryTree categoryTree = new CategoryTree();

    public BaseCategoryTreeInputForm() {
        UIFormInputWithActions categoriesMainTab = new UIFormInputWithActions(CATEGORY_SCOPING);
        this.addChild((UIComponent)categoriesMainTab);
    }

    protected String renderCategoryTree() throws Exception {
        return this.renderCategoryTree(this.categoryTree);
    }

    private String renderCategoryTree(CategoryTree categoryTree) throws Exception {
        UIFormInputWithActions categoryScoping = (UIFormInputWithActions)this.getChildById(CATEGORY_SCOPING);
        StringBuilder builder = new StringBuilder();
        Category category = categoryTree.getCategory();
        List categoryTrees = categoryTree.getSubCategory();
        String clazz = "collapseIcon";
        if (categoryTrees.size() == 0) {
            clazz = "uiIconEmpty";
        }
        if (!category.getId().equals("categories")) {
            UICheckBoxInput checkBoxInput;
            boolean isChecked = category.isView();
            if (this.categoriesChecked != null) {
                isChecked = this.categoriesChecked.isEmpty() || this.categoriesChecked.contains(category.getId());
            }
            this.categoryMap.put(category.getId(), category.getPath());
            if (!this.categoryStatus.containsKey(category.getId())) {
                this.categoryStatus.put(category.getId(), isChecked);
            }
            if ((checkBoxInput = categoryScoping.getUICheckBoxInput(category.getId())) == null) {
                checkBoxInput = new UICheckBoxInput(category.getId(), category.getId(), Boolean.valueOf(isChecked));
                categoryScoping.addUIFormInput((UIFormInput)checkBoxInput);
            }
            checkBoxInput.setValue(Boolean.valueOf(isChecked));
            String categoryName = FAQUtils.getSubString((String)category.getName(), (int)20);
            String tooltip = " rel=\"tooltip\" data-placement=\"bottom\" title=\"" + category.getName() + "\"";
            builder.append("<a href=\"javascript:void(0);\" class=\"uiIconNode ").append(clazz).append("\" onclick=\"eXo.answer.AnswerUtils.showTreeNode(this);\"" + tooltip + ">").append("  <span class=\"uiCheckbox\">").append("    <input onclick=\"eXo.answer.AnswerUtils.checkedNode(this)\" type=\"checkbox\" ").append(isChecked ? "checked " : "").append("name=\"").append(category.getId()).append("\" class=\"checkbox\" id=\"").append(category.getId()).append("\">").append("    <span><i class=\"uiIconCategory uiIconLightGray\"></i> ").append(categoryName).append("</span>").append("  </span>");
            builder.append("</a>");
        }
        if (categoryTrees.size() > 0) {
            builder.append("<ul class=\"nodeGroup\">");
            for (CategoryTree subTree : categoryTrees) {
                builder.append("<li class=\"node\">");
                builder.append(this.renderCategoryTree(subTree));
                builder.append("</li>");
            }
            builder.append("</ul>");
        }
        return builder.toString();
    }
}

