/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.webui;

import javax.portlet.PortletMode;
import org.exoplatform.answer.webui.FAQUtils;
import org.exoplatform.answer.webui.popup.UIFAQSettingForm;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.webui.UIViewer;
import org.exoplatform.forum.common.webui.BuildRendering;
import org.exoplatform.forum.common.webui.UIPopupAction;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/faq/webui/UIFAQPortlet.gtmpl")
public class UIFAQPortlet
extends UIPortletApplication {
    private static final String SLASH = "/";
    private static final String SPACE_PRETTY_NAME = "spacePrettyName";
    private static final String CATEGORY_ID = "categoryId";

    public UIFAQPortlet() throws Exception {
        this.addChild(UIViewer.class, null, null);
        UIPopupAction uiPopup = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        uiPopup.setId("UIFAQPopupAction");
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("UIFAQPopupWindow");
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            this.removeChild(UIFAQSettingForm.class);
            UIViewer uiViewer = (UIViewer)this.getChild(UIViewer.class);
            if (uiViewer == null) {
                uiViewer = (UIViewer)((UIViewer)this.addChild(UIViewer.class, null, null)).setRendered(true);
            }
            this.renderPortletByURL(uiViewer);
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            this.removeChild(UIViewer.class);
            if (this.getChild(UIFAQSettingForm.class) == null) {
                UIFAQSettingForm settingForm = (UIFAQSettingForm)this.addChild(UIFAQSettingForm.class, null, null);
                settingForm.defaulValue();
            }
        }
        BuildRendering.startRender((WebuiRequestContext)context);
        super.processRender(app, context);
        BuildRendering.endRender((WebuiRequestContext)context);
    }

    public void renderPortletByURL(UIViewer uiViewer) throws Exception {
        try {
            PortalRequestContext portalContext = Util.getPortalRequestContext();
            String categoryId = portalContext.getRequestParameter(CATEGORY_ID);
            if (FAQUtils.isFieldEmpty((String)portalContext.getRequestParameter("objectId")) && FAQUtils.isFieldEmpty((String)categoryId) && !portalContext.useAjax() && FAQUtils.isFieldEmpty((String)uiViewer.getPath())) {
                uiViewer.setPath(this.getPathOfCateSpace());
            } else if (!FAQUtils.isFieldEmpty((String)categoryId)) {
                uiViewer.setCategoryId(categoryId);
            } else if (FAQUtils.isFieldEmpty((String)uiViewer.getPath())) {
                uiViewer.setPath("categories");
            }
        }
        catch (Exception e) {
            log.error((Object)"can not render the selected category", (Throwable)e);
        }
    }

    private Space getSpace() {
        return WebUIUtils.getSpaceByContext();
    }

    public String getPathOfCateSpace() {
        Space space = this.getSpace();
        if (space != null) {
            return this.buildPathOfSpace(space.getGroupId());
        }
        return "categories";
    }

    public String getDisplaySpaceName() {
        Space space = this.getSpace();
        if (space != null) {
            return space.getDisplayName();
        }
        return "&nbsp;";
    }

    public String buildPathOfSpace(String spaceGroupId) {
        String groupId = spaceGroupId.replaceAll("/spaces/", "");
        StringBuilder sb = new StringBuilder();
        sb.append("categories").append(SLASH).append(Utils.CATE_SPACE_ID_PREFIX).append(groupId);
        return sb.toString();
    }

    public boolean isInSpace() {
        return this.getSpace() != null;
    }
}

