/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.rendering.MarkupRenderingService;
import org.exoplatform.forum.rendering.api.Renderer;
import org.exoplatform.forum.rendering.core.SupportedSyntaxes;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.JobExecutionContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class CommonUtils {
    private static Log log = ExoLogger.getLogger(CommonUtils.class);
    public static final String COMMA = ",";
    public static final String SLASH = "/";
    public static final String EMPTY_STR = "";
    public static final String COLON = ":";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String ASTERISK_STR = "*";
    public static final String PERCENT_STR = "%";
    public static final String AMP_NUMBER = "&#";
    public static final String LESS_THAN = "&lt;";
    public static final String GREATER_THAN = "&gt;";
    public static final String QUOT = "&quot;";
    public static final String AMP_SPACE = "&nbsp;";
    public static final String AMP_HEX = "&#x26;";
    public static final String AMP = "&amp;";
    public static final String DOMAIN_KEY = "gatein.email.domain.url";
    public static final String FROM_KEY = "gatein.email.smtp.from";
    private static final String SPECIAL_CHARACTOR_FORSERACH_REGEX = "[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]\\?\\*%0-9]";
    private static final String SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX = "[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]0-9]";
    private static final String SPECIAL_CHARACTOR_REGEX = "[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]\\ %0-9]";
    private static List<String> tokens = new ArrayList<String>();
    private static Map<String, String> charcodes = new HashMap<String, String>();
    private static List<String> ignoreLessThanAndGreaterThan = Arrays.asList("&lt;", "&gt;", "&amp;");
    private static int[] CHAR_CODES = new int[]{48, 32, 65, 57, 97, 90, 127, 122, 39};

    public static String generateCheckSum(byte[] b) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(b);
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer(EMPTY_STR);
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.warn((Object)"Can not generate checksum for exporting data");
            return EMPTY_STR;
        }
    }

    public static File getXMLFile(ByteArrayOutputStream bos, String appName, String objectType, Date createDate, String fileName) throws Exception {
        byte[] byteData = bos.toByteArray();
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(byteData);
        Document document = docBuilder.parse(is);
        Attr namespace = document.createAttribute("xmlns:exoks");
        namespace.setValue("http://www.exoplatform.com/exoks/2.0");
        document.getFirstChild().getAttributes().setNamedItem(namespace);
        Attr attName = document.createAttribute("exoks:applicationName");
        attName.setValue(appName);
        document.getFirstChild().getAttributes().setNamedItem(attName);
        Attr dataType = document.createAttribute("exoks:objectType");
        dataType.setValue(objectType);
        document.getFirstChild().getAttributes().setNamedItem(dataType);
        Attr exportDate = document.createAttribute("exoks:exportDate");
        exportDate.setValue(createDate.toString());
        document.getFirstChild().getAttributes().setNamedItem(exportDate);
        Attr checkSum = document.createAttribute("exoks:checkSum");
        checkSum.setValue(CommonUtils.generateCheckSum(byteData));
        document.getFirstChild().getAttributes().setNamedItem(checkSum);
        DOMSource source = new DOMSource(document.getFirstChild());
        File file = new File(fileName + ".xml");
        file.deleteOnExit();
        file.createNewFile();
        StreamResult result = new StreamResult(file);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.transform(source, result);
        return file;
    }

    public static String getImageUrl(String imagePath) throws Exception {
        StringBuilder url = new StringBuilder();
        try {
            ExoContainerContext exoContext = CommonUtils.getComponent(ExoContainerContext.class);
            url.append(SLASH).append(exoContext.getRestContextName());
        }
        catch (Exception e) {
            url.append("/portal");
            log.error((Object)"Can not get portal name or rest context name, exception: ", (Throwable)e);
        }
        RepositoryService rService = CommonUtils.getComponent(RepositoryService.class);
        url.append("/jcr/").append(rService.getCurrentRepository().getConfiguration().getName()).append(imagePath).append(SLASH);
        return url.toString();
    }

    public static String convertCodeHTML(String s) {
        if (CommonUtils.isEmpty(s)) {
            return EMPTY_STR;
        }
        s = s.replaceAll("(<p>((\\&nbsp;)*)(\\s*)?</p>)|(<p>((\\&nbsp;)*)?(\\s*)</p>)", "<br/>").trim();
        s = s.replaceFirst("(<br/>)*", EMPTY_STR);
        s = s.replaceAll("(\\w|\\$)(>?,?\\.?\\*?\\!?\\&?\\%?\\]?\\)?\\}?)(<br/><br/>)*", "$1$2");
        try {
            s = CommonUtils.processBBCode(s);
            s = s.replaceAll("(https?|ftp)://", " $0").replaceAll("(=\"|='|'>|\">)( )(https?|ftp)", "$1$3").replaceAll("[^=\"|^='|^'>|^\">](https?://|ftp://)([-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])", "<a target=\"_blank\" href=\"$1$2\">$1$2</a>");
            s = s.replaceAll("&apos;", "'");
        }
        catch (Exception e) {
            log.error((Object)("Failed to convert HTML" + e.getMessage()));
        }
        return s;
    }

    public static String makeNotificationSender(String from) {
        if (from == null) {
            return null;
        }
        Properties props = new Properties(System.getProperties());
        String mailAddr = props.getProperty(FROM_KEY);
        if (mailAddr == null || mailAddr.length() == 0) {
            mailAddr = props.getProperty("mail.from");
        }
        if (mailAddr != null) {
            try {
                return new InternetAddress(from + "<" + mailAddr + ">").toUnicodeString();
            }
            catch (AddressException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"value of 'gatein.email.smtp.from' or 'mail.from' in configuration file is not in format of mail address", (Throwable)e);
                }
                return null;
            }
        }
        return null;
    }

    public static String getDomainURL() {
        Properties props = new Properties(System.getProperties());
        String domain = props.getProperty(DOMAIN_KEY);
        return CommonUtils.isEmpty(domain) ? EMPTY_STR : domain;
    }

    public static String processBBCode(String s) {
        MarkupRenderingService markupRenderingService = CommonUtils.getComponent(MarkupRenderingService.class);
        Renderer r = markupRenderingService.getRenderer(SupportedSyntaxes.bbcode.name());
        return r.render(s);
    }

    public static ExoContainer getExoContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = context.getJobDetail().getKey().getGroup();
        if (portalName == null) {
            portalName = PortalContainer.getCurrentPortalContainerName();
        }
        if (portalName.indexOf(COLON) > 0) {
            portalName = portalName.substring(0, portalName.indexOf(COLON));
        }
        return ExoContainerContext.getContainerByName((String)portalName);
    }

    public static String getRSSLink(String appType, String portalName, String objectId) {
        return SLASH + PortalContainer.getInstance().getRestContextName() + "/ks/" + appType + "/rss/" + objectId;
    }

    public static String getUserRSSLink(String apptype, String userId) {
        return SLASH + PortalContainer.getInstance().getRestContextName() + "/ks/" + apptype + "/rss/user/" + userId;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() <= 0;
    }

    public static boolean isEmpty(String[] array) {
        if (array != null && array.length > 0) {
            for (String s : array) {
                if (s == null || s.trim().length() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static String removeSpecialCharacterForSearch(String input) {
        if (CommonUtils.isEmpty(input)) {
            return input;
        }
        String result = input.replaceAll(SPECIAL_CHARACTOR_FORSERACH_REGEX, SPACE);
        result = result.replaceAll("\\s+", SPACE);
        return result.trim();
    }

    public static String removeSpecialCharacterForUnifiedSearch(String input) {
        String[] tab;
        if (CommonUtils.isEmpty(input)) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (String s : tab = input.split(SPACE)) {
            if (CommonUtils.isEmpty(s)) continue;
            String searchTerm = s.split("~")[0];
            searchTerm = CommonUtils.encodeSpecialCharToHTMLnumber(searchTerm.replaceAll(SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX, EMPTY_STR), "~", true);
            builder.append(searchTerm).append(SPACE);
        }
        return builder.toString().trim();
    }

    public static String processUnifiedSearchSearchCondition(String input) {
        String[] tab;
        if (CommonUtils.isEmpty(input) || input.indexOf("~") < 0 || input.indexOf("\\~") > 0) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (String s : tab = input.split(SPACE)) {
            if (CommonUtils.isEmpty(s)) continue;
            String searchTerm = s.split("~")[0];
            String similarity = s.split("~")[1];
            searchTerm = CommonUtils.encodeSpecialCharToHTMLnumber(searchTerm.replaceAll(SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX, EMPTY_STR), "~", true);
            builder.append(searchTerm).append("~").append(similarity).append(SPACE);
        }
        return builder.toString().trim();
    }

    public static String processLikeCondition(String input) {
        String[] tab;
        StringBuilder builder = new StringBuilder();
        for (String s : tab = input.split(SPACE)) {
            if (CommonUtils.isEmpty(s)) continue;
            String searchTerm = s.split("~")[0];
            searchTerm = CommonUtils.encodeSpecialCharToHTMLnumber(searchTerm.replaceAll(SPECIAL_CHARACTOR_FOR_UNIFIED_SERACH_REGEX, EMPTY_STR), "~", true);
            builder.append(PERCENT_STR).append(searchTerm).append(PERCENT_STR).append(SPACE);
        }
        return builder.toString().trim();
    }

    public static boolean hasSpecialCharacter(String input) {
        if (CommonUtils.isEmpty(input)) {
            return false;
        }
        String result = input.replaceAll(SPECIAL_CHARACTOR_REGEX, EMPTY_STR).replaceAll("_", EMPTY_STR);
        return !result.equals(input);
    }

    public static String processSearchCondition(String searchCondition) {
        if (CommonUtils.isEmpty(searchCondition)) {
            return searchCondition;
        }
        StringBuffer searchConditionBuffer = new StringBuffer();
        if (!(searchCondition = CommonUtils.removeSpecialCharacterForSearch(searchCondition)).contains(ASTERISK_STR) && !searchCondition.contains(PERCENT_STR)) {
            if (!searchCondition.startsWith(ASTERISK_STR)) {
                searchConditionBuffer.append(ASTERISK_STR).append(searchCondition);
            }
            if (!searchCondition.endsWith(ASTERISK_STR)) {
                searchConditionBuffer.append(ASTERISK_STR);
            }
        } else {
            searchCondition = searchCondition.replace(ASTERISK_STR, PERCENT_STR);
            searchConditionBuffer.append(PERCENT_STR).append(searchCondition).append(PERCENT_STR);
        }
        return searchConditionBuffer.toString();
    }

    public static String encodeSpecialCharInSearchTerm(String s) {
        String charIgnore = "&#<>[]/:?\"'=.,*$%()\\+@!^*-}{;`~_";
        if (!CommonUtils.isEmpty(s)) {
            int i = 0;
            while (charIgnore.indexOf(String.valueOf(s.charAt(i))) >= 0) {
                if (++i != s.length()) continue;
                charIgnore = EMPTY_STR;
                break;
            }
        }
        if (!CommonUtils.isEmpty(charIgnore)) {
            charIgnore = "&</>!#:?=.,+;~`_";
        }
        return CommonUtils.encodeSpecialCharToHTMLnumber(s, charIgnore, true);
    }

    public static String encodeSpecialCharInTitle(String s) {
        if (!CommonUtils.isEmpty(s)) {
            while (s.indexOf("  ") >= 0) {
                s = StringUtils.replace((String)s, (String)"  ", (String)SPACE).trim();
            }
        }
        String charIgnore = "!#:?=.,+;~`_";
        return CommonUtils.encodeSpecialCharToHTMLnumber(s, charIgnore, true);
    }

    public static String encodeSpecialCharInContent(String s) {
        String charIgnore = "&#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_";
        return CommonUtils.encodeSpecialCharToHTMLnumber(s, charIgnore, false);
    }

    public static boolean isContainSpecialCharacter(String s) {
        if (CommonUtils.isEmpty(s)) {
            return false;
        }
        String charIgnore = "&#<>[]/:?\"=.,*$%()\\+@!^*-}{;`~_";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charIgnore.indexOf(String.valueOf(c)) < 0) continue;
            return true;
        }
        return false;
    }

    public static String encodeSpecialCharToHTMLnumber(String s, String charIgnore, boolean isTitle) {
        if (CommonUtils.isEmpty(s)) {
            return EMPTY_STR;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (charIgnore.indexOf(String.valueOf(c)) >= 0) {
                builder.append(c);
                continue;
            }
            int t = s.codePointAt(i);
            if (t < CHAR_CODES[0] && t > CHAR_CODES[1] || t < CHAR_CODES[2] && t > CHAR_CODES[3] || t < CHAR_CODES[4] && t > CHAR_CODES[5] || t < CHAR_CODES[6] && t > CHAR_CODES[7]) {
                if (isTitle && (t == 60 || t == 62)) {
                    if (t == 60) {
                        builder.append(LESS_THAN);
                        continue;
                    }
                    if (t != 62) continue;
                    builder.append(GREATER_THAN);
                    continue;
                }
                builder.append(AMP_NUMBER).append(t).append(SEMICOLON);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String decodeSpecialCharToHTMLnumber(String s, List<String> lIgnore) {
        if (CommonUtils.isEmpty(s)) {
            return s;
        }
        for (String token : tokens) {
            if (token == null || lIgnore.contains(token) || s.indexOf(token) < 0) continue;
            s = StringUtils.replace((String)s, (String)token, (String)charcodes.get(token));
        }
        return s;
    }

    public static String decodeSpecialCharToHTMLnumber(String s) {
        return CommonUtils.decodeSpecialCharToHTMLnumber(s, new ArrayList<String>());
    }

    public static String decodeSpecialCharToHTMLnumberIgnore(String str) {
        return CommonUtils.decodeSpecialCharToHTMLnumber(str, ignoreLessThanAndGreaterThan);
    }

    public static Calendar getGreenwichMeanTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static <T> T getComponent(Class<T> type) {
        return type.cast(PortalContainer.getInstance().getComponentInstanceOfType(type));
    }

    public static SessionProvider createSystemProvider() {
        SessionProviderService sessionProviderService = CommonUtils.getComponent(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }

    static {
        if (tokens.size() <= 0) {
            for (int t = 0; t < 0x10FFFF; ++t) {
                if (!(t < CHAR_CODES[0] && t > CHAR_CODES[1] || t < CHAR_CODES[2] && t > CHAR_CODES[3] || t < CHAR_CODES[4] && t > CHAR_CODES[5]) && (t >= CHAR_CODES[6] || t <= CHAR_CODES[7])) continue;
                String token = AMP_NUMBER + t + SEMICOLON;
                tokens.add(token);
                charcodes.put(token, String.valueOf(Character.toChars(t)[0]));
            }
            tokens.add(LESS_THAN);
            charcodes.put(LESS_THAN, "<");
            tokens.add(GREATER_THAN);
            charcodes.put(GREATER_THAN, ">");
            tokens.add(QUOT);
            charcodes.put(QUOT, "\"");
            tokens.add(AMP_SPACE);
            charcodes.put(AMP_SPACE, SPACE);
            tokens.add(AMP_HEX);
            charcodes.put(AMP_HEX, "&");
            tokens.add(AMP);
            charcodes.put(AMP, "&");
        }
    }
}

