/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.common.webui.UIPopupAction;
import org.exoplatform.forum.common.webui.UIPopupContainer;
import org.exoplatform.forum.common.webui.UISelectComponent;
import org.exoplatform.forum.common.webui.UISelector;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.organization.UIGroupMembershipSelector;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/forum/common/UIGroupSelector.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={SelectMembershipActionListener.class}), @EventConfig(listeners={SelectPathActionListener.class})}), @ComponentConfig(type=UITree.class, id="UITreeGroupSelector", template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})}), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbGroupSelector", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={UIBreadcumbs.SelectPathActionListener.class})})})
public class UIGroupSelector
extends UIGroupMembershipSelector
implements UIPopupComponent,
UISelectComponent {
    private UIComponent uiComponent;
    private String type_ = null;
    private List<Group> selectedGroup_;
    private String returnFieldName = null;
    private String spaceGroupId = null;
    private String spaceParentId = null;
    private OrganizationService service = UserHelper.getOrganizationService();

    public void processRender(WebuiRequestContext context) throws Exception {
        UITree uiTree;
        Group parentGroup;
        if (!CommonUtils.isEmpty(this.spaceGroupId) && (parentGroup = (Group)(uiTree = (UITree)this.getChild(UITree.class)).getParentSelected()) == null) {
            uiTree.setParentSelected(null);
        }
        super.processRender(context);
    }

    public UIComponent getReturnComponent() {
        return this.uiComponent;
    }

    public String getReturnField() {
        return this.returnFieldName;
    }

    @Override
    public void setComponent(UIComponent uicomponent, String[] initParams) {
        this.uiComponent = uicomponent;
        if (initParams == null || initParams.length <= 0) {
            return;
        }
        for (int i = 0; i < initParams.length; ++i) {
            if (initParams[i].indexOf("returnField") > -1) {
                String[] array = initParams[i].split("=");
                this.returnFieldName = array[1];
                break;
            }
            this.returnFieldName = initParams[0];
        }
    }

    public List<Group> getChildGroup() throws Exception {
        return UserHelper.findGroups(this.getCurrentGroup());
    }

    public boolean isSelectGroup() {
        return TYPE_GROUP.equals(this.type_);
    }

    public boolean isSelectUser() {
        return TYPE_USER.equals(this.type_);
    }

    public boolean isSelectMemberShip() {
        return TYPE_MEMBERSHIP.equals(this.type_);
    }

    public List<String> getList() throws Exception {
        ArrayList<String> children = new ArrayList<String>();
        if (this.isSelectUser()) {
            ListAccess userPageList = this.service.getUserHandler().findUsersByGroupId(this.getCurrentGroup().getId());
            User[] users = (User[])userPageList.load(0, userPageList.getSize());
            for (int i = 0; i < userPageList.getSize(); ++i) {
                children.add(users[i].getUserName());
            }
        } else if (this.isSelectMemberShip()) {
            for (String child : this.getListMemberhip()) {
                children.add(child);
            }
        } else if (this.isSelectGroup() && this.getCurrentGroup() != null) {
            if (!CommonUtils.isEmpty(this.spaceGroupId) && this.getCurrentGroup().getId().equals(this.spaceParentId)) {
                Group group = this.service.getGroupHandler().findGroupById(this.spaceGroupId);
                children.add(group.getGroupName());
            } else {
                Collection groups = this.service.getGroupHandler().findGroups(this.getCurrentGroup());
                if (groups.size() > 0) {
                    for (Group child : groups) {
                        children.add(child.getGroupName());
                    }
                } else {
                    children.add(WebUIUtils.getLabel(this.getId(), "selectThisGroup"));
                }
            }
        }
        return children;
    }

    public void setSelectedGroups(List<Group> groups) {
        if (groups != null) {
            this.selectedGroup_ = groups;
            ((UITree)this.getChild(UITree.class)).setSibbling(this.selectedGroup_);
        }
    }

    public void setSpaceGroupId(String groupId) throws Exception {
        if (!CommonUtils.isEmpty(groupId)) {
            Group group = this.service.getGroupHandler().findGroupById(groupId);
            if (group != null) {
                this.spaceGroupId = groupId;
                this.selectedGroup_ = new ArrayList<Group>();
                this.selectedGroup_.add(group);
                this.spaceParentId = group.getParentId();
                this.changeGroup(this.spaceParentId);
            }
        } else {
            this.setSelectedGroups(null);
        }
    }

    public void changeGroup(String groupId) throws Exception {
        super.changeGroup(groupId);
        if (this.selectedGroup_ != null) {
            UITree tree = (UITree)this.getChild(UITree.class);
            tree.setSibbling(this.selectedGroup_);
            tree.setChildren(null);
        }
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public void setType(String type) {
        this.type_ = type;
    }

    public String getType() {
        return this.type_;
    }

    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIGroupSelector uiGroupSelector = (UIGroupSelector)((UIBreadcumbs)event.getSource()).getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiGroupSelector.changeGroup(objectId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiGroupSelector);
        }
    }

    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            UIGroupSelector uiGroupSelector = (UIGroupSelector)((UITree)event.getSource()).getAncestorOfType(UIGroupSelector.class);
            String groupId = event.getRequestContext().getRequestParameter("objectId");
            uiGroupSelector.changeGroup(groupId);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiGroupSelector);
        }
    }

    public static class SelectMembershipActionListener
    extends EventListener<UIGroupSelector> {
        public void execute(Event<UIGroupSelector> event) throws Exception {
            String user = event.getRequestContext().getRequestParameter("objectId");
            UIGroupSelector uiGroupSelector = (UIGroupSelector)event.getSource();
            String returnField = uiGroupSelector.getReturnField();
            ((UISelector)uiGroupSelector.getReturnComponent()).updateSelect(returnField, user);
            try {
                UIPopupContainer popupContainer = (UIPopupContainer)uiGroupSelector.getAncestorOfType(UIPopupContainer.class);
                UIPopupAction popupAction = uiGroupSelector.getParent().getId().equals(popupContainer.getId()) ? (UIPopupAction)popupContainer.getAncestorOfType(UIPopupAction.class) : (UIPopupAction)popupContainer.getChild(UIPopupAction.class);
                popupAction.deActivate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupAction);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiGroupSelector.getReturnComponent());
            }
            catch (NullPointerException e) {
                UIPopupAction uiPopup = (UIPopupAction)uiGroupSelector.getAncestorOfType(UIPopupAction.class);
                uiPopup.deActivate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiGroupSelector.getReturnComponent());
            }
        }
    }
}

